/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.pixelmonmod.pixelmon.Pixelmon;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.http.Consts;

public class PokePasteHelper {
    private static final BitSet URLENCODER = new BitSet(256);
    private static final int RADIX = 16;
    private static final String NAME_VALUE_SEPARATOR = "=";

    public static Builder builder() {
        return new Builder();
    }

    public static CompletableFuture<Optional<String>> upload(String paste, String title, String author) {
        return CompletableFuture.supplyAsync(() -> {
            String post = PokePasteHelper.format(Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"paste", (Object)paste), Pair.of((Object)"title", (Object)title), Pair.of((Object)"author", (Object)author)}), "ascii");
            try {
                HttpURLConnection connection = PokePasteHelper.createPOSTRequest(post);
                return Optional.ofNullable(connection.getHeaderField("Location"));
            }
            catch (IOException e) {
                Pixelmon.LOGGER.catching((Throwable)e);
                return Optional.empty();
            }
        }, Pixelmon.POOL);
    }

    private static HttpURLConnection createPOSTRequest(String text) throws IOException {
        byte[] postAsBytes = text.getBytes(StandardCharsets.US_ASCII);
        HttpURLConnection connection = PokePasteHelper.createUrlConnection(postAsBytes);
        try (OutputStream outputStream = connection.getOutputStream();){
            PokePasteHelper.write(postAsBytes, outputStream);
        }
        return connection;
    }

    private static HttpURLConnection createUrlConnection(byte[] postAsBytes) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL("https://pokepast.es/create").openConnection(Proxy.NO_PROXY);
        connection.setConnectTimeout(15000);
        connection.setReadTimeout(15000);
        connection.setUseCaches(false);
        connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=US-ASCII");
        connection.setRequestProperty("Content-Length", String.valueOf(postAsBytes.length));
        connection.setDoOutput(true);
        connection.setInstanceFollowRedirects(false);
        return connection;
    }

    public static void write(byte[] data, OutputStream output) throws IOException {
        if (data != null) {
            output.write(data);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String format(List<Pair<String, String>> parameters, String charset) {
        return PokePasteHelper.format(parameters, '&', charset);
    }

    public static String format(List<Pair<String, String>> parameters, char parameterSeparator, String charset) {
        StringBuilder result = new StringBuilder();
        for (Pair<String, String> parameter : parameters) {
            String encodedName = PokePasteHelper.encodeFormFields((String)parameter.getFirst(), charset);
            String encodedValue = PokePasteHelper.encodeFormFields((String)parameter.getSecond(), charset);
            if (result.length() > 0) {
                result.append(parameterSeparator);
            }
            result.append(encodedName);
            if (encodedValue == null) continue;
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encodeFormFields(String content, String charset) {
        if (content == null) {
            return null;
        }
        return PokePasteHelper.urlEncode(content, charset != null ? Charset.forName(charset) : Consts.UTF_8, URLENCODER, true);
    }

    private static String urlEncode(String content, Charset charset, BitSet safechars, boolean blankAsPlus) {
        if (content == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        ByteBuffer bb = charset.encode(content);
        while (bb.hasRemaining()) {
            int b = bb.get() & 0xFF;
            if (safechars.get(b)) {
                buf.append((char)b);
                continue;
            }
            if (blankAsPlus && b == 32) {
                buf.append('+');
                continue;
            }
            buf.append("%");
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            buf.append(hex1);
            buf.append(hex2);
        }
        return buf.toString();
    }

    public static class Builder {
        protected String paste;
        protected String author;
        protected String title;

        protected Builder() {
        }

        public Builder paste(String paste) {
            this.paste = paste;
            return this;
        }

        public Builder author(String author) {
            this.author = author;
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public CompletableFuture<Optional<String>> execute() {
            return PokePasteHelper.upload(this.paste, this.author, this.title);
        }
    }
}

