/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.test.notexamples;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.events.battles.BattleTickEvent;
import com.pixelmonmod.pixelmon.api.events.battles.TurnEndEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonBuilder;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import com.pixelmonmod.pixelmon.api.test.TestResult;
import com.pixelmonmod.pixelmon.api.test.UnitTest;
import com.pixelmonmod.pixelmon.battles.api.BattleBuilder;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRules;
import com.pixelmonmod.pixelmon.battles.controller.ai.NoOpAI;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.enums.EnumOldGenMode;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class TypeTesting {
    @UnitTest(value="Normal doesn't damage ghost")
    public static CompletableFuture<TestResult> testNormalDoesNotDamageGhost() {
        WildPixelmonParticipant bulbasaur = TypeTesting.createParticipant(PokemonBuilder.builder().species(PixelmonSpecies.ORICORIO.getValue()).form("baile").build());
        WildPixelmonParticipant gastly = TypeTesting.createParticipant(PokemonBuilder.builder().species(PixelmonSpecies.GASTLY.getValue()).build());
        return ((CompletableFuture)BattleBuilder.builder().frozen().rules(new BattleRules(BattleType.SINGLE).set(BattleRuleRegistry.GEN_MODE, (Object)EnumOldGenMode.Both)).teamOne(bulbasaur).teamTwo(gastly).start().thenCompose(controller -> {
            bulbasaur.asWrapper().setAttack(AttackRegistry.TACKLE.get().ofMutable(), (List<PixelmonWrapper>)Lists.newArrayList((Object[])new PixelmonWrapper[]{gastly.asWrapper()}), false);
            bulbasaur.asWrapper().useAttack();
            controller.addTaskAtEvent(BattleTickEvent.Pre.class, (pre, bc) -> controller.endTurn());
            return controller.addFunctionAtEvent(TurnEndEvent.class, (turnEndEvent, bc) -> bc);
        })).thenApply(controller -> {
            if ((double)bulbasaur.asWrapper().getHealthPercent() == 100.0 && (double)gastly.asWrapper().getHealthPercent() == 100.0) {
                return TestResult.success();
            }
            return TestResult.failure("Tackle effect dealt damage to Gastly");
        });
    }

    private static WildPixelmonParticipant createParticipant(Pokemon pokemon) {
        WildPixelmonParticipant participant = new WildPixelmonParticipant(pokemon);
        participant.setBattleAI(new NoOpAI(participant));
        return participant;
    }
}

