/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.storage;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.PokemonFactory;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.PokemonStorage;
import com.pixelmonmod.pixelmon.api.storage.StoragePosition;
import com.pixelmonmod.pixelmon.api.util.helpers.NetworkHelper;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.ClientSetPacket;
import com.pixelmonmod.pixelmon.comm.packetHandlers.clientStorage.newStorage.SetTempMode;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.tools.Quadstate;
import java.awt.Color;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class PartyStorage
extends PokemonStorage {
    public static final int MAX_PARTY = 6;
    protected Pokemon[] party = new Pokemon[6];
    protected Pokemon[] tempParty = null;
    protected Color tempPartyColor;

    public PartyStorage(UUID uuid) {
        super(uuid);
    }

    public boolean inTemporaryMode() {
        return this.tempParty != null;
    }

    public void copyToTemporaryMode(Color color) {
        Pokemon[] clonedParty = new Pokemon[6];
        for (int i = 0; i < this.party.length; ++i) {
            Pokemon pokemon = this.party[i];
            if (pokemon == null) continue;
            clonedParty[i] = PokemonFactory.copy(pokemon);
        }
        this.setInTemporaryMode(true, color, clonedParty);
    }

    public void enterTemporaryMode() {
        this.enterTemporaryMode(Color.RED);
    }

    public void enterTemporaryMode(Color color) {
        this.setInTemporaryMode(true, color, new Pokemon[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setInTemporaryModeClient(boolean tempMode, Color color) {
        if (tempMode) {
            if (this.tempParty == null) {
                this.tempParty = new Pokemon[6];
            }
            this.tempPartyColor = color;
        } else {
            this.tempParty = null;
            this.tempPartyColor = null;
        }
    }

    public void setInTemporaryMode(boolean tempMode, Color color, Pokemon ... pokemons) {
        block6: {
            block5: {
                for (ServerPlayerEntity serverPlayerEntity : this.getPlayersToUpdate()) {
                    NetworkHelper.sendPacket(new SetTempMode(tempMode, color), serverPlayerEntity);
                }
                this.tempPartyColor = color;
                if (!tempMode) break block5;
                this.tempParty = new Pokemon[6];
                if (pokemons == null) break block6;
                for (int i = 0; i < 6; ++i) {
                    if (pokemons.length > i) {
                        this.tempParty[i] = pokemons[i];
                    }
                    for (ServerPlayerEntity serverPlayerEntity : this.getPlayersToUpdate()) {
                        NetworkHelper.sendPacket(new ClientSetPacket(this, new StoragePosition(-1, i), this.tempParty[i], new EnumUpdateType[0]), serverPlayerEntity);
                    }
                }
                break block6;
            }
            this.tempParty = null;
            this.setTempPartyColor(null);
            for (int i = 0; i < 6; ++i) {
                this.notifyListeners(new StoragePosition(-1, i), this.get(i), new EnumUpdateType[0]);
            }
        }
    }

    public void setTempPartyColor(Color tempPartyColor) {
        this.tempPartyColor = tempPartyColor;
        for (ServerPlayerEntity serverPlayerEntity : this.getPlayersToUpdate()) {
            NetworkHelper.sendPacket(new SetTempMode(this.inTemporaryMode(), tempPartyColor), serverPlayerEntity);
        }
    }

    public Color getTempPartyColor() {
        if (this.tempPartyColor == null) {
            this.setTempPartyColor(Color.CYAN);
        }
        return this.tempPartyColor;
    }

    @Override
    public Pokemon[] getAll() {
        if (this.inTemporaryMode()) {
            return Arrays.copyOf(this.tempParty, 6);
        }
        return Arrays.copyOf(this.party, 6);
    }

    public Pokemon[] getOriginalParty() {
        return Arrays.copyOf(this.party, 6);
    }

    @Override
    public CompoundNBT writeToNBT(CompoundNBT nbt) {
        int i;
        for (i = 0; i < 6; ++i) {
            if (this.party[i] == null) continue;
            nbt.func_218657_a("party" + i, (INBT)this.party[i].writeToNBT(new CompoundNBT()));
        }
        nbt.func_74757_a("TempPartyEnabled", this.inTemporaryMode());
        if (this.inTemporaryMode()) {
            for (i = 0; i < this.tempParty.length; ++i) {
                if (this.tempParty[i] == null) continue;
                nbt.func_218657_a("TempParty" + i, (INBT)this.tempParty[i].writeToNBT(new CompoundNBT()));
            }
            nbt.func_74768_a("TempPartyColor", this.getTempPartyColor().getRGB());
        }
        return nbt;
    }

    @Override
    public PartyStorage readFromNBT(CompoundNBT nbt) {
        int i;
        for (i = 0; i < 6; ++i) {
            if (nbt.func_74764_b("party" + i)) {
                this.party[i] = PokemonFactory.create(nbt.func_74775_l("party" + i));
                this.party[i].setStorage(this, new StoragePosition(-1, i));
                continue;
            }
            this.party[i] = null;
        }
        if (nbt.func_74767_n("TempPartyEnabled")) {
            this.tempParty = new Pokemon[6];
            for (i = 0; i < 6; ++i) {
                if (nbt.func_74764_b("TempParty" + i)) {
                    this.tempParty[i] = PokemonFactory.create(nbt.func_74775_l("TempParty" + i));
                    this.tempParty[i].setStorage(this, new StoragePosition(-1, i));
                    continue;
                }
                this.tempParty[i] = null;
            }
            this.tempPartyColor = new Color(nbt.func_74762_e("TempPartyColor"));
        }
        return this;
    }

    @Override
    @Nullable
    public StoragePosition getFirstEmptyPosition() {
        for (int i = 0; i < 6; ++i) {
            if ((!this.inTemporaryMode() || this.tempParty[i] != null) && (this.inTemporaryMode() || this.party[i] != null)) continue;
            return new StoragePosition(-1, i);
        }
        return null;
    }

    @Override
    public void forEach(BiConsumer<Pokemon, StoragePosition> action) {
        for (int i = 0; i < 6; ++i) {
            action.accept(this.inTemporaryMode() ? this.tempParty[i] : this.party[i], new StoragePosition(-1, i));
        }
    }

    public void setOriginal(int slot, Pokemon pokemon) {
        this.setOriginal(new StoragePosition(-1, slot), pokemon);
    }

    public void setOriginal(StoragePosition position, Pokemon pokemon) {
        this.party[position.order] = pokemon;
        this.setNeedsSaving();
        if (pokemon != null) {
            pokemon.setStorage(this, position);
        }
        this.notifyListeners(position, pokemon, new EnumUpdateType[0]);
    }

    @Override
    public void set(StoragePosition position, Pokemon pokemon) {
        if (this.inTemporaryMode()) {
            this.tempParty[position.order] = pokemon;
            this.setNeedsSaving();
            if (pokemon != null) {
                pokemon.setStorage(this, position);
            }
            this.notifyListeners(position, pokemon, new EnumUpdateType[0]);
            return;
        }
        this.party[position.order] = pokemon;
        this.setNeedsSaving();
        if (pokemon != null) {
            pokemon.setStorage(this, position);
        }
        this.notifyListeners(position, pokemon, new EnumUpdateType[0]);
    }

    public void set(int slot, Pokemon pokemon) {
        this.set(new StoragePosition(-1, slot), pokemon);
    }

    @Override
    @Nullable
    public Pokemon get(StoragePosition position) {
        return this.get(position.order);
    }

    @Nullable
    public Pokemon get(int slot) {
        if (slot < 0 || slot > this.party.length) {
            return null;
        }
        if (this.inTemporaryMode()) {
            return this.tempParty[slot];
        }
        return this.party[slot];
    }

    public Pokemon get(UUID pokemonUUID) {
        return this.get(this.getSlot(pokemonUUID));
    }

    public int getSlot(Pokemon pokemon) {
        return this.getSlot(pokemon.getUUID());
    }

    public int getSlot(UUID pokemonUUID) {
        for (int i = 0; i < 6; ++i) {
            if (this.inTemporaryMode() && this.tempParty[i] != null && Objects.equals(this.tempParty[i].getUUID(), pokemonUUID)) {
                return i;
            }
            if (this.party[i] == null || !Objects.equals(this.party[i].getUUID(), pokemonUUID)) continue;
            return i;
        }
        return -1;
    }

    public List<Pokemon> getTeam() {
        ArrayList team = Lists.newArrayListWithCapacity((int)6);
        for (Pokemon pokemon : this.inTemporaryMode() ? this.tempParty : this.party) {
            if (pokemon == null || pokemon.isEgg()) continue;
            team.add(pokemon);
        }
        return team;
    }

    public void heal() {
        for (Pokemon pokemon : this.getTeam()) {
            pokemon.heal();
        }
    }

    @Override
    public void swap(StoragePosition position1, StoragePosition position2) {
        if (this.inTemporaryMode()) {
            Pokemon temp = this.tempParty[position1.order];
            this.tempParty[position1.order] = this.tempParty[position2.order];
            this.tempParty[position2.order] = temp;
            this.setNeedsSaving();
            if (this.tempParty[position1.order] != null) {
                this.tempParty[position1.order].setStorage(this, position1);
            }
            if (this.tempParty[position2.order] != null) {
                this.tempParty[position2.order].setStorage(this, position2);
            }
            this.notifyListeners(position1, this.tempParty[position1.order], new EnumUpdateType[0]);
            this.notifyListeners(position2, this.tempParty[position2.order], new EnumUpdateType[0]);
            return;
        }
        Pokemon temp = this.party[position1.order];
        this.party[position1.order] = this.party[position2.order];
        this.party[position2.order] = temp;
        this.setNeedsSaving();
        if (this.party[position1.order] != null) {
            this.party[position1.order].setStorage(this, position1);
        }
        if (this.party[position2.order] != null) {
            this.party[position2.order].setStorage(this, position2);
        }
        this.notifyListeners(position1, this.party[position1.order], new EnumUpdateType[0]);
        this.notifyListeners(position2, this.party[position2.order], new EnumUpdateType[0]);
    }

    public void swap(int slot1, int slot2) {
        this.swap(new StoragePosition(-1, slot1), new StoragePosition(-1, slot2));
    }

    @Override
    public StoragePosition getPosition(Pokemon pokemon) {
        if (this.inTemporaryMode()) {
            for (int i = 0; i < 6; ++i) {
                if (this.tempParty[i] != pokemon && (this.tempParty[i] == null || !this.tempParty[i].getUUID().equals(pokemon.getUUID()))) continue;
                return new StoragePosition(-1, i);
            }
            return null;
        }
        for (int i = 0; i < 6; ++i) {
            if (this.party[i] != pokemon && (this.party[i] == null || !this.party[i].getUUID().equals(pokemon.getUUID()))) continue;
            return new StoragePosition(-1, i);
        }
        return null;
    }

    @Override
    public List<ServerPlayerEntity> getPlayersToUpdate() {
        return new ArrayList<ServerPlayerEntity>();
    }

    @Override
    public File getFile() {
        return new File(ServerLifecycleHooks.getCurrentServer().func_71218_a((RegistryKey)World.field_234918_g_).func_217481_x().field_215759_d, "pokemon/" + this.uuid.toString() + ".pk");
    }

    public int countAblePokemon() {
        int c = 0;
        for (Pokemon pokemon : this.inTemporaryMode() ? this.tempParty : this.party) {
            if (pokemon == null || !pokemon.canBattle()) continue;
            ++c;
        }
        return c;
    }

    public int getHighestLevel() {
        int lvl = 1;
        for (Pokemon pokemon : this.inTemporaryMode() ? this.tempParty : this.party) {
            if (pokemon == null) continue;
            lvl = Math.max(lvl, pokemon.getPokemonLevel());
        }
        return lvl;
    }

    public int getAverageLevel() {
        float c = 0.0f;
        int levelSum = 0;
        for (Pokemon pokemon : this.inTemporaryMode() ? this.tempParty : this.party) {
            if (pokemon == null || pokemon.isEgg()) continue;
            c += 1.0f;
            levelSum += pokemon.getPokemonLevel();
        }
        if (c == 0.0f) {
            return 1;
        }
        return (int)((float)levelSum / c);
    }

    public int getLowestLevel() {
        int level = 100;
        for (Pokemon pokemon : this.inTemporaryMode() ? this.tempParty : this.party) {
            if (pokemon == null || pokemon.isEgg() || pokemon.getPokemonLevel() >= level) continue;
            level = pokemon.getPokemonLevel();
        }
        return level;
    }

    public Pokemon getFirstAblePokemon() {
        return this.findOne((Pokemon pk) -> {
            PixelmonEntity pixelmon = pk.getPixelmonEntity().orElse(null);
            if (pixelmon != null && pixelmon.battleController != null) {
                return false;
            }
            return pk.canBattle();
        });
    }

    public Pokemon getFirstBattleReadyPokemon() {
        return this.findOne((Pokemon pokemon) -> {
            if (pokemon != null && pokemon.getPixelmonWrapperFromPlayerEntity().isPresent()) {
                return false;
            }
            return pokemon.canBattle();
        });
    }

    public PixelmonEntity getAndSendOutFirstAblePokemon(Entity parent) {
        Pokemon pokemon = this.getFirstAblePokemon();
        if (pokemon == null) {
            return null;
        }
        return pokemon.getOrSpawnPixelmon(parent);
    }

    public Quadstate isOldGen(RegistryKey<World> dimension) {
        boolean oldGenDimension = PixelmonConfigProxy.getGeneral().getOldGenDimensions().contains(dimension.getRegistryName().toString());
        boolean bothGenDimension = PixelmonConfigProxy.getGeneral().getBothGenDimensions().contains(dimension.getRegistryName().toString());
        boolean relaxedRules = PixelmonConfigProxy.getBattle().isRelaxedBattleGimmickRules();
        if (this instanceof PlayerPartyStorage) {
            PlayerPartyStorage pps = (PlayerPartyStorage)this;
            return pps.getMegaItem().canSpecialEvolve() ? Quadstate.valueOf(pps.getMegaItem().canMega()) : Quadstate.NONE;
        }
        return bothGenDimension || relaxedRules ? Quadstate.BOTH : Quadstate.valueOf(oldGenDimension);
    }
}

