/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.calculators;

import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.BetterSpawnerConfig;
import com.pixelmonmod.pixelmon.api.events.spawning.SpawnLocationEvent;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.conditions.LocationType;
import com.pixelmonmod.pixelmon.api.spawning.util.SpawningHeightmap;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.api.world.MutableLocation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.eventbus.api.Event;

public interface CalculateSpawnLocations {
    public static final int[] POSITIVE_AND_NEGATIVE_ONE = new int[]{-1, 1};
    public static final int MIN_DIAMETER = 1;

    public static CalculateSpawnLocations getDefault() {
        return new DummyImpl();
    }

    default public int getMaxSpawnLocationDiameter() {
        return 10;
    }

    default public ArrayList<SpawnLocation> calculateSpawnableLocations(BlockCollection collection) {
        ArrayList<SpawnLocation> spawnableLocations = new ArrayList<SpawnLocation>();
        World world = collection.world;
        int minX = collection.minX + 1;
        int minY = collection.minY + 1;
        int minZ = collection.minZ + 1;
        int maxX = collection.maxX - 1;
        int maxY = collection.maxY - 1;
        int maxZ = collection.maxZ - 1;
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int baseX = minX; baseX <= maxX; ++baseX) {
            for (int baseZ = minZ; baseZ <= maxZ; ++baseZ) {
                block2: for (int baseY = maxY - 1; baseY >= minY; --baseY) {
                    MutableLocation loc;
                    SpawnLocation spawnLocation;
                    SpawnLocationEvent event;
                    List<LocationType> types;
                    blockPos.func_181079_c(baseX, baseY + 1, baseZ);
                    if (!world.func_175723_af().func_177746_a((BlockPos)blockPos) || (types = LocationType.getPotentialTypes(collection.getBlockState(baseX, baseY, baseZ))).isEmpty()) continue;
                    int r = 0;
                    int diameter = 0;
                    block3: while (diameter <= this.getMaxSpawnLocationDiameter()) {
                        int y = blockPos.func_177956_o() + r;
                        for (int sign : POSITIVE_AND_NEGATIVE_ONE) {
                            for (int x : new int[]{blockPos.func_177958_n() + r * sign, blockPos.func_177958_n()}) {
                                for (int z : new int[]{blockPos.func_177952_p() + r * sign, blockPos.func_177952_p()}) {
                                    if (collection.isOutOfBounds(x, y, z)) {
                                        if (r > 1) break block3;
                                        continue block2;
                                    }
                                    BlockState rstate = collection.getBlockState(x, y, z);
                                    if (rstate == null) break block3;
                                    if (diameter <= 1) {
                                        types.removeIf(type -> !type.surroundingBlockCondition.test(rstate));
                                        if (types.isEmpty()) {
                                            continue block2;
                                        }
                                    } else {
                                        for (LocationType type2 : types) {
                                            if (type2.surroundingBlockCondition.test(rstate)) continue;
                                            break block3;
                                        }
                                    }
                                    if (r == 0) break;
                                }
                                if (r == 0) break;
                            }
                            ++diameter;
                        }
                        ++r;
                    }
                    boolean canSeeSky = SpawningHeightmap.canSeeSky((BlockPos)blockPos, world);
                    HashSet finalTypes = Sets.newHashSet();
                    if (!types.isEmpty()) {
                        for (int i = 0; i < types.size(); ++i) {
                            LocationType type3 = types.get(i);
                            if (type3.seesSky != null && canSeeSky != type3.seesSky || type3.neededNearbyBlockCondition != null && !type3.neededNearbyBlockCondition.test(collection.getUniqueBlocks())) continue;
                            finalTypes.add(type3);
                        }
                    }
                    if (finalTypes.isEmpty() || Pixelmon.EVENT_BUS.post((Event)(event = new SpawnLocationEvent(spawnLocation = new SpawnLocation(collection.cause, loc = new MutableLocation(world, baseX, baseY + 1, baseZ), finalTypes, collection.getBlockState(baseX, baseY, baseZ).func_177230_c(), collection.getUniqueBlocks(), collection.getBiome(baseX, baseZ), canSeeSky, diameter, collection.getLight(baseX, baseY + 1, baseZ)))))) continue;
                    spawnableLocations.add(event.getSpawnLocation());
                }
            }
        }
        return spawnableLocations;
    }

    default public boolean isBlockAboveAir(BlockCollection blockCollection, BlockPos pos) {
        BlockState state = blockCollection.getBlockState(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p());
        if (state == null) {
            return true;
        }
        return BetterSpawnerConfig.doesBlockSeeSky(state);
    }

    public static class DummyImpl
    implements CalculateSpawnLocations {
    }
}

