/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.spawning.archetypes.algorithms.checkspawns;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.events.spawning.LegendaryCheckSpawnsEvent;
import com.pixelmonmod.pixelmon.api.spawning.AbstractSpawner;
import com.pixelmonmod.pixelmon.api.spawning.SpawnInfo;
import com.pixelmonmod.pixelmon.api.spawning.SpawnLocation;
import com.pixelmonmod.pixelmon.api.spawning.calculators.CheckSpawns;
import com.pixelmonmod.pixelmon.api.util.helpers.TextHelper;
import com.pixelmonmod.pixelmon.api.world.BlockCollection;
import com.pixelmonmod.pixelmon.spawning.LegendarySpawner;
import com.pixelmonmod.pixelmon.spawning.PixelmonSpawning;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;

public class LegendaryCheckSpawns
implements CheckSpawns {
    public String node;

    public LegendaryCheckSpawns(String node) {
        this.node = node;
    }

    @Override
    public String getPermissionNode() {
        return this.node;
    }

    @Override
    public void checkSpawns(AbstractSpawner spawner, CommandSource sender, List<String> arguments) {
        if (!(spawner instanceof LegendarySpawner)) {
            return;
        }
        LegendaryCheckSpawnsEvent event = new LegendaryCheckSpawnsEvent(sender);
        Pixelmon.EVENT_BUS.post((Event)event);
        LegendarySpawner lSpawner = (LegendarySpawner)spawner;
        ServerPlayerEntity target = null;
        ArrayList<ServerPlayerEntity> targets = new ArrayList<ServerPlayerEntity>();
        if (!(sender.func_197022_f() instanceof ServerPlayerEntity)) {
            PlayerList playerList = ServerLifecycleHooks.getCurrentServer().func_184103_al();
            for (String argument : arguments) {
                if (!spawner.name.equals(argument) && (target = playerList.func_152612_a(argument)) != null) break;
            }
        }
        if (target == null) {
            targets.addAll(ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v());
        } else {
            targets.add(target);
        }
        HashMap<String, Double> totalPercentages = new HashMap<String, Double>();
        double percentageSum = 0.0;
        for (ServerPlayerEntity player : targets) {
            BlockCollection blocks = spawner.getTrackedBlockCollection((Entity)player, 0.0f, 0.0f, lSpawner.horizontalSliceRadius, lSpawner.verticalSliceRadius, 0, 0).join();
            ArrayList<SpawnLocation> spawnLocations = lSpawner.spawnLocationCalculator.calculateSpawnableLocations(blocks);
            HashMap<SpawnLocation, List<SpawnInfo>> possibleSpawns = new HashMap<SpawnLocation, List<SpawnInfo>>();
            for (SpawnLocation spawnLocation : spawnLocations) {
                List<SpawnInfo> spawns = spawner.getSuitableSpawns(spawnLocation);
                if (spawns.isEmpty()) continue;
                possibleSpawns.put(spawnLocation, spawns);
            }
            Map<String, Double> percentages = spawner.selectionAlgorithm.getPercentages(spawner, possibleSpawns);
            for (Map.Entry<String, Double> entry : percentages.entrySet()) {
                totalPercentages.put(entry.getKey(), entry.getValue() + totalPercentages.getOrDefault(entry.getKey(), 0.0));
                percentageSum += entry.getValue().doubleValue();
            }
        }
        DecimalFormat df = new DecimalFormat(".####", DecimalFormatSymbols.getInstance(Locale.US));
        DecimalFormat df2 = new DecimalFormat(".##", DecimalFormatSymbols.getInstance(Locale.US));
        if (percentageSum > 100.0) {
            double multiplier = 100.0 / percentageSum;
            for (String key : totalPercentages.keySet()) {
                double d = (Double)totalPercentages.get(key) * multiplier;
                if (d < 0.01 || d > 99.99) {
                    totalPercentages.put(key, Double.parseDouble(df.format(d)));
                    continue;
                }
                totalPercentages.put(key, Double.parseDouble(df2.format(d)));
            }
        }
        ServerLifecycleHooks.getCurrentServer().execute(() -> {
            ArrayList<IFormattableTextComponent> messages = new ArrayList<IFormattableTextComponent>();
            long timeToGo = lSpawner.nextSpawnTime - System.currentTimeMillis();
            int minutes = (int)Math.ceil((float)timeToGo / 1000.0f / 60.0f);
            if (event.shouldShowTime) {
                messages.add(TextHelper.translate(TextFormatting.GOLD, "spawning.checkspawns.timeuntilnextattempt1").func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)TextHelper.translate(TextFormatting.DARK_AQUA, "spawning.checkspawns.timeuntilnextattempt2", minutes)));
            }
            if (event.shouldShowChance) {
                messages.add(TextHelper.translate(TextFormatting.GOLD, "spawning.checkspawns.chanceofspawning").func_230529_a_((ITextComponent)new StringTextComponent(" " + TextFormatting.DARK_AQUA + new DecimalFormat(".##").format((lSpawner == PixelmonSpawning.legendarySpawner ? PixelmonConfigProxy.getSpawning().getLegendarySpawnChance() : PixelmonConfigProxy.getSpawning().getBossSpawning().getBossSpawnChance()) * 100.0f) + "%")));
            }
            messages.add(TextHelper.translate(TextFormatting.AQUA, "spawning.checkspawns.possiblespawns"));
            messages.addAll(this.generateMessages(totalPercentages, arguments));
            for (ITextComponent iTextComponent : messages) {
                sender.func_197030_a(iTextComponent, false);
            }
        });
    }
}

