/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.enums.ExperienceGainType;
import com.pixelmonmod.pixelmon.api.events.ExperienceGainEvent;
import com.pixelmonmod.pixelmon.api.events.LevelUpEvent;
import com.pixelmonmod.pixelmon.api.pokemon.ExperienceGroup;
import com.pixelmonmod.pixelmon.api.pokemon.LearnMoveController;
import com.pixelmonmod.pixelmon.api.pokemon.item.pokeball.PokeBallRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.pokemon.stats.PermanentStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.DelegateLink;
import com.pixelmonmod.pixelmon.battles.api.rules.BattleRuleRegistry;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.comm.PixelmonStatsData;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQuery;
import com.pixelmonmod.pixelmon.entities.pixelmon.helpers.EvolutionQueryList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.eventbus.api.Event;

public class PokemonLevel {
    protected DelegateLink pixelmon;
    protected ExperienceGainType lastLevelType = ExperienceGainType.UNKNOWN;
    public int expToNextLevel = 0;
    int oldLevel = -1;

    public PokemonLevel(DelegateLink p) {
        this.pixelmon = p;
    }

    protected void updateStats() {
        this.pixelmon.updateStats();
    }

    public void writeToNBT(CompoundNBT var1) {
        ExperienceGroup experienceGroup = this.pixelmon.getPokemon().getForm().getExperienceGroup();
        var1.func_74768_a("Level", this.getPokemonLevel());
        var1.func_74768_a("EXP", this.getExp());
        var1.func_74768_a("EXPToNextLevel", this.canLevelUp() ? experienceGroup.getExpForLevel(this.getPokemonLevel() + 1) - experienceGroup.getExpForLevel(this.getPokemonLevel()) : 0);
    }

    public void readFromNBT(CompoundNBT var1) {
        this.setExp(var1.func_74762_e("EXP"));
        this.setLevel(var1.func_74762_e("Level"));
    }

    public int getPokemonLevel() {
        return this.pixelmon.getPokemonLevel();
    }

    public void setLevel(int i) {
        this.pixelmon.setLevel(i);
        this.updateExpToNextLevel();
        PermanentStats permanentStats = this.pixelmon.getStats();
        if (this.pixelmon.getHealth() == permanentStats.getHP() || this.pixelmon.getHealth() == -1) {
            this.updateStats();
            this.pixelmon.setHealthDirect(this.pixelmon.getStats().getHP());
        } else {
            float oldHP = permanentStats.getHP();
            float oldHealth = this.pixelmon.getHealth();
            this.updateStats();
            float newHealth = permanentStats.getHP();
            if (oldHP != 0.0f) {
                newHealth = oldHealth / oldHP * (float)permanentStats.getHP();
            }
            this.pixelmon.setHealthDirect((int)Math.ceil(newHealth));
        }
    }

    public ExperienceGainType getLastLevelType() {
        return this.lastLevelType;
    }

    public void updateExpToNextLevel() {
        ExperienceGroup experienceGroup = this.pixelmon.getPokemon().getForm().getExperienceGroup();
        this.expToNextLevel = this.getPokemonLevel() == 1 ? experienceGroup.getExpForLevel(this.getPokemonLevel() + 1) : (this.canLevelUp() ? experienceGroup.getExpForLevel(this.getPokemonLevel() + 1) - experienceGroup.getExpForLevel(this.getPokemonLevel()) : 0);
    }

    public int getExp() {
        return this.pixelmon.getExp();
    }

    public void setExp(int experience) {
        this.pixelmon.setExp(experience);
    }

    public boolean canLevelUp() {
        return this.getPokemonLevel() < PixelmonServerConfig.maxLevel;
    }

    protected void onLevelUp(PixelmonStatsData stats) {
        this.updateStats();
        this.pixelmon.updateLevelUp(stats);
        int amount = this.pixelmon.getFriendship() < 100 ? 5 : (this.pixelmon.getFriendship() < 200 ? 3 : 2);
        this.pixelmon.adjustFriendship(amount + (this.pixelmon.getBall().is(PokeBallRegistry.LUXURY_BALL) ? 1 : 0));
    }

    public void awardEXP(int experience) {
        this.awardEXP(experience, ExperienceGainType.UNKNOWN);
    }

    public void awardEXP(int experience, ExperienceGainType type) {
        this.awardEXP(null, experience, type);
    }

    public void awardEXP(@Nullable BattleController controller, int experience, ExperienceGainType type) {
        if (!this.pixelmon.doesLevel()) {
            return;
        }
        ExperienceGainEvent event = new ExperienceGainEvent(controller, this.pixelmon, experience, type);
        if (Pixelmon.EVENT_BUS.post((Event)event)) {
            return;
        }
        experience = event.getExperience();
        this.setExp(this.getExp() + experience);
        ServerPlayerEntity owner = this.pixelmon.getPlayerOwner();
        BattleController bc = this.pixelmon.getBattleController();
        if (owner != null && this.canLevelUp() && experience > 0) {
            TranslationTextComponent message = ChatHandler.getMessage("pixelmon.stats.gainexp", this.pixelmon.getRealNickname(), experience);
            if (bc != null) {
                ChatHandler.sendBattleMessage((Entity)owner, message);
            } else {
                ChatHandler.sendChat((ICommandSource)owner, message);
            }
        }
        if (!this.canLevelUp() || this.expToNextLevel == -1) {
            this.setExp(0);
            return;
        }
        if (owner == null) {
            return;
        }
        boolean isReplacingMove = false;
        boolean didLevel = false;
        while (this.getExp() >= this.expToNextLevel) {
            this.pixelmon.update(EnumUpdateType.Name);
            int newExp = this.getExp() - this.expToNextLevel;
            LevelUpEvent.Pre preEvent = new LevelUpEvent.Pre(owner, this.pixelmon, type, this.getPokemonLevel(), this.getPokemonLevel() + 1);
            if (!this.canLevelUp() || Pixelmon.EVENT_BUS.post((Event)preEvent)) break;
            didLevel = true;
            this.lastLevelType = type;
            PixelmonStatsData stats = PixelmonStatsData.createPacket(this.pixelmon);
            this.setLevel(preEvent.getAfterLevel());
            this.onLevelUp(stats);
            this.setExp(newExp);
            int newLevel = this.getPokemonLevel();
            List<ImmutableAttack> newAttacks = this.pixelmon.getBaseStats().getMoves().getMovesAtLevel(newLevel);
            for (ImmutableAttack a : newAttacks) {
                Moveset moveset = this.pixelmon.getMoveset();
                if (moveset.hasAttack(a)) continue;
                if (moveset.size() >= 4) {
                    isReplacingMove = true;
                    LearnMoveController.sendLearnMove(owner, this.pixelmon.getPokemonUUID(), a, true);
                    continue;
                }
                moveset.add(new Attack(a));
                this.pixelmon.update(EnumUpdateType.Moveset);
                TranslationTextComponent message = ChatHandler.getMessage("pixelmon.stats.learnedmove", this.pixelmon.getRealNickname(), a.getTranslatedName());
                if (bc != null) {
                    ChatHandler.sendBattleMessage((Entity)owner, message);
                    continue;
                }
                ChatHandler.sendChat((ICommandSource)owner, message);
            }
            if (bc != null && bc.rules.getOrDefault(BattleRuleRegistry.LEVEL_CAP) < PixelmonServerConfig.maxLevel && bc.rules.getOrDefault(BattleRuleRegistry.LEVEL_CAP) >= newLevel) {
                this.setExp(0);
                Pixelmon.EVENT_BUS.post((Event)new LevelUpEvent.Post(owner, this.pixelmon, type, preEvent.getBeforeLevel(), preEvent.getAfterLevel()));
                break;
            }
            Pixelmon.EVENT_BUS.post((Event)new LevelUpEvent.Post(owner, this.pixelmon, type, preEvent.getBeforeLevel(), preEvent.getAfterLevel()));
        }
        this.pixelmon.update(EnumUpdateType.Stats);
        if (didLevel && !isReplacingMove) {
            if (this.pixelmon.getBattleController() == null) {
                this.pixelmon.pokemon.tryEvolution();
            } else {
                this.pixelmon.getBattleController().checkedPokemon.add(this.pixelmon.pokemon);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForExistingEvolutionQuery() {
        List<EvolutionQuery> list = EvolutionQueryList.queryList;
        synchronized (list) {
            for (int i = 0; i < EvolutionQueryList.queryList.size(); ++i) {
                if (!EvolutionQueryList.queryList.get((int)i).pokemonUUID.equals(this.pixelmon.getPokemonUUID())) continue;
                return true;
            }
        }
        return false;
    }

    public void recalculateXP() {
        this.setExp(0);
        ExperienceGroup experienceGroup = this.pixelmon.getPokemon().getForm().getExperienceGroup();
        this.expToNextLevel = experienceGroup.getExpForLevel(this.getPokemonLevel() + 1) - experienceGroup.getExpForLevel(this.getPokemonLevel());
    }

    public float getExpFraction() {
        return PokemonLevel.getExpFraction(this.getExp(), this.expToNextLevel);
    }

    public static float getExpFraction(int exp, int expToNextLevel) {
        if (expToNextLevel == 0) {
            return 0.0f;
        }
        return (float)exp / (float)expToNextLevel;
    }

    public int getExpForNextLevelClient() {
        ExperienceGroup experienceGroup = this.pixelmon.getPokemon().getForm().getExperienceGroup();
        if (this.oldLevel != this.getPokemonLevel()) {
            this.expToNextLevel = experienceGroup.getExpForLevel(this.getPokemonLevel() + 1) - experienceGroup.getExpForLevel(this.getPokemonLevel());
            this.oldLevel = this.getPokemonLevel();
        }
        return this.expToNextLevel;
    }

    public int getExpForLevel(int level) {
        ExperienceGroup experienceGroup = this.pixelmon.getPokemon().getForm().getExperienceGroup();
        return experienceGroup.getExpForLevel(level) - experienceGroup.getExpForLevel(level - 1);
    }
}

