/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.battles.AttackCategory;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.enums.TriBoolean;
import com.pixelmonmod.pixelmon.api.events.pokemon.MovesetEvent;
import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.api.pokemon.ability.abilities.ComingSoon;
import com.pixelmonmod.pixelmon.api.pokemon.stats.links.PokemonLink;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.RandomAccess;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.eventbus.api.Event;

public class Moveset
extends AbstractList<Attack>
implements RandomAccess,
Cloneable {
    private static final EnumUpdateType[] MOVESET = new EnumUpdateType[]{EnumUpdateType.Moveset};
    public Pokemon pokemon = null;
    public Attack[] attacks = new Attack[4];
    protected Ability ability;
    protected String tempAbility;
    private final List<ImmutableAttack> reminderMoves = Lists.newArrayList();

    public Moveset() {
    }

    public Moveset(Attack[] attacks, Ability ability) {
        this.attacks = attacks;
        this.ability = ability;
    }

    public Moveset(Attack attack, Ability ability) {
        this.attacks[0] = attack;
        this.ability = ability;
    }

    public Moveset withPokemon(Pokemon pokemon) {
        this.pokemon = pokemon;
        return this;
    }

    public void setTempAbility(String tempAbility) {
        this.tempAbility = tempAbility;
    }

    public String getTempAbility() {
        return this.tempAbility;
    }

    @Override
    public Attack get(int index) {
        if (index < 0 || index > 3) {
            return null;
        }
        return this.attacks[index];
    }

    @Override
    public boolean add(Attack a) {
        if (this.size() >= 4) {
            return false;
        }
        this.set(this.size(), a);
        return true;
    }

    @Override
    public Attack set(int index, Attack a) {
        Attack previousAttack = this.attacks[index];
        this.attacks[index] = a;
        this.tryNotifyPokemon();
        if (this.pokemon == null || this.pokemon.getOwnerPlayer() == null) {
            return previousAttack;
        }
        if (previousAttack != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.ForgotMoveEvent(this.pokemon, this, previousAttack));
        }
        if (a != null) {
            Pixelmon.EVENT_BUS.post((Event)new MovesetEvent.LearntMoveEvent(this.pokemon, this, previousAttack, a));
        }
        return previousAttack;
    }

    public void tryNotifyPokemon() {
        if (this.pokemon != null) {
            this.pokemon.markDirty(MOVESET);
        }
    }

    public void swap(int index, int index2) {
        Attack a = this.attacks[index];
        this.attacks[index] = this.attacks[index2];
        this.attacks[index2] = a;
        this.tryNotifyPokemon();
    }

    @Override
    public Attack remove(int index) {
        Attack a = this.get(index);
        int oldSize = this.size();
        for (int i = index + 1; i < this.size(); ++i) {
            this.set(i - 1, this.get(i));
        }
        this.set(oldSize - 1, null);
        return a;
    }

    @Override
    public boolean removeIf(Predicate<? super Attack> predicate) {
        for (int i = 0; i < this.attacks.length; ++i) {
            if (!predicate.test(this.attacks[i])) continue;
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (!(o instanceof Attack)) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] != o) continue;
            this.set(i, null);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            if (this.attacks[i] == null) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (this.isEmpty()) {
            return false;
        }
        if (o instanceof Attack) {
            for (int i = 0; i < this.size(); ++i) {
                if (!this.attacks[i].equals(o)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void clear() {
        this.attacks = new Attack[4];
    }

    public void writeToNBT(CompoundNBT nbt) {
        ListNBT list = new ListNBT();
        for (int i = 0; i < this.size(); ++i) {
            Attack attack = this.get(i);
            if (attack == null || attack.getActualMove() == null) continue;
            CompoundNBT compound = new CompoundNBT();
            compound.func_74778_a("MoveID", attack.getActualMove().getAttackName());
            compound.func_74774_a("MovePP", (byte)attack.pp);
            if (attack.ppLevel != 0) {
                compound.func_74774_a("MovePPLevel", (byte)attack.ppLevel);
            }
            list.add((Object)compound);
        }
        nbt.func_218657_a("Moveset", (INBT)list);
        if (this.tempAbility != null) {
            nbt.func_74778_a("TempAbiliy", this.tempAbility);
        }
        if (this.ability != null) {
            nbt.func_74778_a("Ability", this.ability.getName());
        }
        ListNBT relearn = new ListNBT();
        this.reminderMoves.forEach(ab -> relearn.add((Object)StringNBT.func_229705_a_((String)ab.getAttackName())));
        nbt.func_218657_a("RelrnMoves", (INBT)relearn);
    }

    public void readFromNBT(CompoundNBT nbt) {
        this.clear();
        ListNBT list = nbt.func_150295_c("Moveset", 10);
        for (INBT base : list) {
            CompoundNBT compound = (CompoundNBT)base;
            String moveID = compound.func_74779_i("MoveID");
            Optional<ImmutableAttack> attack = AttackRegistry.getAttackBase(moveID);
            if (!attack.isPresent()) {
                short numericID = compound.func_74765_d("MoveID");
                attack = AttackRegistry.fromAttackIndex(numericID);
            }
            if (!attack.isPresent()) continue;
            short movePP = compound.func_74765_d("MovePP");
            short movePPLevel = compound.func_74765_d("MovePPLevel");
            Attack mutableAttack = attack.get().ofMutable();
            mutableAttack.pp = movePP;
            mutableAttack.ppLevel = movePPLevel;
            this.add(mutableAttack);
        }
        if (nbt.func_74764_b("TempAbility")) {
            this.tempAbility = nbt.func_74779_i("TempAbility");
        }
        if (nbt.func_74764_b("Ability")) {
            this.ability = AbilityRegistry.getAbility(nbt.func_74779_i("Ability")).orElse(ComingSoon.noAbility);
        }
        this.reminderMoves.clear();
        if (nbt.func_74764_b("RelrnMoves")) {
            list = nbt.func_150295_c("RelrnMoves", 8);
            for (INBT base : list) {
                AttackRegistry.getAttackBase(base.func_150285_a_()).ifPresent(this.reminderMoves::add);
            }
        }
    }

    public void fromBytes(PacketBuffer buf) {
        this.clear();
        int numberOfMoves = buf.readByte();
        for (int j = 0; j < numberOfMoves; ++j) {
            Attack attack = new Attack(buf.func_218666_n());
            attack.pp = buf.readByte();
            attack.ppLevel = buf.readByte();
            attack.overridePPMax(buf.readByte());
            attack.setDisabled(buf.readBoolean(), null);
            this.attacks[j] = attack;
        }
        if (buf.readBoolean()) {
            this.tempAbility = buf.func_218666_n();
        }
        if (buf.readBoolean()) {
            this.ability = AbilityRegistry.getAbility(buf.func_218666_n()).orElse(ComingSoon.noAbility);
        }
    }

    public void toBytes(PacketBuffer buf) {
        buf.writeByte(this.size());
        for (Attack a : this.attacks) {
            if (a == null) continue;
            buf.func_180714_a(a.getActualMove().getAttackName());
            buf.writeByte(a.pp);
            buf.writeByte(a.ppLevel);
            buf.writeByte(a.getOverriddenPPMax() == null ? -1 : a.getOverriddenPPMax());
            buf.writeBoolean(a.getDisabled());
        }
        buf.writeBoolean(this.tempAbility != null);
        if (this.tempAbility != null) {
            buf.func_180714_a(this.tempAbility);
        }
        buf.writeBoolean(this.ability != null);
        if (this.ability != null) {
            buf.func_180714_a(this.ability.getName());
        }
    }

    public void addCurrentMovesToReminder() {
        for (Attack attack : this.attacks) {
            if (attack == null || this.reminderMoves.contains(attack.getActualMove())) continue;
            this.reminderMoves.add(attack.getActualMove());
        }
    }

    public void removeMovesFromReminder(ImmutableAttack ... moves) {
        this.removeMovesFromReminder(Arrays.asList(moves));
    }

    public void removeMovesFromReminder(Collection<ImmutableAttack> moves) {
        this.reminderMoves.removeAll(moves);
    }

    public boolean hasAttack(Attack a) {
        for (Attack attack : this.attacks) {
            if (attack == null || !Objects.equals(attack.getActualMove().getAttackName(), a.getActualMove().getAttackName())) continue;
            return true;
        }
        return false;
    }

    public boolean hasAttack(ImmutableAttack ... moves) {
        for (Attack attack : this.attacks) {
            for (ImmutableAttack base : moves) {
                if (attack == null || !attack.getActualMove().equals(base)) continue;
                return true;
            }
        }
        return false;
    }

    @SafeVarargs
    public final boolean hasAttack(Optional<ImmutableAttack> ... moves) {
        for (Attack attack : this.attacks) {
            for (Optional<ImmutableAttack> base : moves) {
                if (!base.isPresent() || attack == null || !attack.getActualMove().equals(base.get())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasAttackCategory(AttackCategory attackCategory) {
        for (Attack attack : this.attacks) {
            if (attack == null || attack.getActualMove().getAttackCategory() != attackCategory) continue;
            return true;
        }
        return false;
    }

    public boolean hasOffensiveAttackType(Element ... types) {
        for (Attack attack : this.attacks) {
            for (Element type : types) {
                if (attack == null || attack.getActualMove().getAttackCategory() == AttackCategory.STATUS || attack.getType() != type) continue;
                return true;
            }
        }
        return false;
    }

    public boolean removeAttack(ImmutableAttack removedAttack) {
        if (removedAttack == null) {
            return false;
        }
        boolean removed = false;
        for (int i = 0; i < this.attacks.length; ++i) {
            Attack attack = this.attacks[i];
            if (attack == null || !attack.isAttack(removedAttack)) continue;
            this.remove(i);
            removed = true;
        }
        return removed;
    }

    @SafeVarargs
    public final void removeAttack(Optional<ImmutableAttack> ... removedAttack) {
        for (Optional<ImmutableAttack> immutableAttack : removedAttack) {
            this.removeAttack((ImmutableAttack)immutableAttack.orElse(null));
        }
    }

    public void replaceWith(List<String> attackIds) {
        this.clear();
        for (String attackIndex : attackIds) {
            this.add(new Attack(attackIndex));
        }
    }

    public boolean hasFullPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack a = this.attacks[i];
            if (a == null || a.pp >= a.getMaxPP()) continue;
            return false;
        }
        return true;
    }

    public Moveset copy() {
        Attack[] attacks = new Attack[this.attacks.length];
        for (int i = 0; i < this.attacks.length; ++i) {
            if (this.attacks[i] == null) continue;
            attacks[i] = this.attacks[i].deepCopy();
        }
        return new Moveset(attacks, this.ability);
    }

    public boolean replaceMove(Optional<ImmutableAttack> oldMove, Attack newMove) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.attacks[i] == null || !this.attacks[i].isAttack(oldMove)) continue;
            this.attacks[i] = newMove;
            this.tryNotifyPokemon();
            return true;
        }
        return false;
    }

    public void healAllPP() {
        for (int i = 0; i < this.size(); ++i) {
            Attack attack = this.attacks[i];
            if (attack == null) continue;
            attack.pp = attack.getMaxPP();
        }
        this.tryNotifyPokemon();
    }

    public List<ImmutableAttack> getReminderMoves() {
        return this.reminderMoves;
    }

    public static Moveset loadMoveset(PokemonLink pokemon) {
        return pokemon.getBaseStats().getMoves().loadMoveset(pokemon.getPokemonLevel());
    }

    public Ability getAbility() {
        return this.ability;
    }

    public void setAbility(Ability ability) {
        this.ability = ability;
        this.tryNotifyPokemon();
    }

    public boolean isHiddenAbility(Pokemon pokemon) {
        return pokemon.getForm().getAbilities().isHiddenAbility(this.ability);
    }

    public TriBoolean isHiddenAbility() {
        if (this.pokemon != null) {
            return TriBoolean.valueOf(this.isHiddenAbility(this.pokemon));
        }
        return TriBoolean.NULL;
    }

    public boolean addImmutable(Collection<ImmutableAttack> attacks) {
        ArrayList mutableAttacks = Lists.newArrayList();
        for (ImmutableAttack attack : attacks) {
            mutableAttacks.add(attack.ofMutable());
        }
        return this.addAll(mutableAttacks);
    }

    public boolean addImmutable(ImmutableAttack ... attacks) {
        ArrayList mutableAttacks = Lists.newArrayList();
        for (ImmutableAttack attack : attacks) {
            mutableAttacks.add(new Attack(attack));
        }
        return this.addAll(mutableAttacks);
    }

    public List<ImmutableAttack> asImmutable() {
        ArrayList attacks = Lists.newArrayList();
        for (Attack attack : this.attacks) {
            if (attack == null) continue;
            attacks.add(attack.getActualMove());
        }
        return attacks;
    }

    public boolean hasAbility() {
        return this.ability != null;
    }

    public void removeIllegalMoves() {
        if (this.pokemon == null) {
            return;
        }
        List<ImmutableAttack> moves = this.pokemon.getForm().getMoves().getAllMoves();
        for (int i = this.size() - 1; i >= 0; --i) {
            Attack attack = this.get(i);
            if (attack == null || moves.contains(attack.getActualMove())) continue;
            this.remove(i);
        }
    }

    @Override
    public String toString() {
        return "Moveset{pokemon=" + this.pokemon + ", attacks=" + Arrays.toString(this.attacks) + ", ability=" + this.ability + ", reminderMoves=" + this.reminderMoves + '}';
    }
}

