/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.stats;

import com.google.common.collect.Maps;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.species.Species;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.BlocksWalkedOutsideBallStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.LakeTrioStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MeltanStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MewStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.MoveUsesStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.RecoilStats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.extraStats.ShearableStats;
import com.pixelmonmod.pixelmon.api.registries.PixelmonSpecies;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;

public abstract class ExtraStats {
    private static final Map<Integer, Supplier<? extends ExtraStats>> STATS_SUPPLIERS = Maps.newHashMap();

    public abstract void writeToNBT(CompoundNBT var1);

    public abstract void readFromNBT(CompoundNBT var1);

    public abstract ExtraStats copy();

    public static void init() {
        PixelmonSpecies.MEW.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), MewStats::new));
        PixelmonSpecies.AZELF.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), LakeTrioStats::new));
        PixelmonSpecies.UXIE.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), LakeTrioStats::new));
        PixelmonSpecies.MESPRIT.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), LakeTrioStats::new));
        PixelmonSpecies.MELTAN.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), MeltanStats::new));
        PixelmonSpecies.MAREEP.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), ShearableStats::new));
        PixelmonSpecies.WOOLOO.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), ShearableStats::new));
        PixelmonSpecies.DUBWOOL.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), ShearableStats::new));
        PixelmonSpecies.BASCULIN.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), RecoilStats::new));
        PixelmonSpecies.PRIMEAPE.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), MoveUsesStats::new));
        PixelmonSpecies.QWILFISH.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), MoveUsesStats::new));
        PixelmonSpecies.STANTLER.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), MoveUsesStats::new));
        PixelmonSpecies.BRAMBLIN.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), BlocksWalkedOutsideBallStats::new));
        PixelmonSpecies.PAWMO.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), BlocksWalkedOutsideBallStats::new));
        PixelmonSpecies.RELLOR.ifInitialized(species -> STATS_SUPPLIERS.put(species.getDex(), BlocksWalkedOutsideBallStats::new));
    }

    public static ExtraStats getExtraStats(Species p) {
        Supplier<? extends ExtraStats> supplier = STATS_SUPPLIERS.get(p.getDex());
        if (supplier == null) {
            return null;
        }
        return supplier.get();
    }

    public boolean hasSpecialSetup() {
        return false;
    }

    public void specialPrep(Pokemon pokemon) {
    }
}

