/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.typeadapters;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.api.pokemon.species.moves.Moves;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen1TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen2TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen3TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen4TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen5TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen6TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen7TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen9TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Set;

public class MovesTypeAdapter
implements JsonSerializer<Moves>,
JsonDeserializer<Moves> {
    private static final JsonArray EMPTY = new JsonArray();

    public Moves deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject object = json.getAsJsonObject();
        Moves.Builder builder = Moves.builder();
        for (JsonElement levelUpMove : this.getJsonArrayIfPresent(object, "levelUpMoves")) {
            JsonObject moveObject = levelUpMove.getAsJsonObject();
            int level = moveObject.get("level").getAsInt();
            for (JsonElement attacks : moveObject.get("attacks").getAsJsonArray()) {
                builder.levelUpMoves(level, (ImmutableAttack)context.deserialize(attacks, ImmutableAttack.class));
            }
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves")) {
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tutorMoves : this.getJsonArrayIfPresent(object, "tutorMoves")) {
            builder.tutorMoves((ImmutableAttack)context.deserialize(tutorMoves, ImmutableAttack.class));
        }
        for (JsonElement eggMove : this.getJsonArrayIfPresent(object, "eggMoves")) {
            builder.eggMoves((ImmutableAttack)context.deserialize(eggMove, ImmutableAttack.class));
        }
        for (JsonElement transferMove : this.getJsonArrayIfPresent(object, "transferMoves")) {
            builder.transferMoves((ImmutableAttack)context.deserialize(transferMove, ImmutableAttack.class));
        }
        for (JsonElement hmMove : this.getJsonArrayIfPresent(object, "hmMoves")) {
            builder.hmMoves((ImmutableAttack)context.deserialize(hmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves9")) {
            builder.tmMoves9(Gen9TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement trMove : this.getJsonArrayIfPresent(object, "trMoves")) {
            Gen8TechnicalRecords tr = Gen8TechnicalRecords.getTr(trMove.getAsString());
            if (tr == null) {
                Pixelmon.LOGGER.error("Invalid TR found `" + trMove.getAsString() + "`");
            }
            builder.trMoves(tr);
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves8")) {
            builder.tmMoves8(Gen8TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves7")) {
            builder.tmMoves7(Gen7TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves6")) {
            builder.tmMoves6(Gen6TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves5")) {
            builder.tmMoves5(Gen5TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves4")) {
            builder.tmMoves4(Gen4TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves3")) {
            builder.tmMoves3(Gen3TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves2")) {
            builder.tmMoves2(Gen2TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        for (JsonElement tmMove : this.getJsonArrayIfPresent(object, "tmMoves1")) {
            builder.tmMoves1(Gen1TechnicalMachines.getTm(tmMove.getAsString()));
            builder.tmMoves((ImmutableAttack)context.deserialize(tmMove, ImmutableAttack.class));
        }
        return builder.build();
    }

    private JsonArray getJsonArrayIfPresent(JsonObject object, String name) {
        if (!object.has(name)) {
            return EMPTY;
        }
        return object.getAsJsonArray(name);
    }

    public JsonElement serialize(Moves src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject object = new JsonObject();
        JsonArray array = new JsonArray();
        for (Map.Entry<Integer, Set<ImmutableAttack>> entry : src.getPokemonLevelUpMoves().entrySet()) {
            JsonObject jsonObject = new JsonObject();
            JsonArray jsonArray = new JsonArray();
            for (ImmutableAttack attack : entry.getValue()) {
                jsonArray.add(context.serialize((Object)attack));
            }
            jsonObject.add("attacks", (JsonElement)jsonArray);
            jsonObject.addProperty("level", (Number)entry.getKey());
            array.add((JsonElement)jsonObject);
        }
        object.add("levelUpMoves", (JsonElement)array);
        JsonArray tmMoveArray = new JsonArray();
        for (ImmutableAttack immutableAttack : src.getTMMoves()) {
            tmMoveArray.add(context.serialize((Object)immutableAttack));
        }
        object.add("tmMoves", (JsonElement)tmMoveArray);
        JsonArray jsonArray = new JsonArray();
        for (ImmutableAttack immutableAttack : src.getTutorMoves()) {
            jsonArray.add(context.serialize((Object)immutableAttack));
        }
        object.add("tutorMoves", (JsonElement)jsonArray);
        JsonArray jsonArray2 = new JsonArray();
        for (ImmutableAttack immutableAttack : src.getEggMoves()) {
            jsonArray2.add(context.serialize((Object)immutableAttack));
        }
        object.add("eggMoves", (JsonElement)jsonArray2);
        JsonArray jsonArray3 = new JsonArray();
        for (ImmutableAttack transferMove : src.getTransferMoves()) {
            jsonArray3.add(context.serialize((Object)transferMove));
        }
        object.add("transferMoves", (JsonElement)jsonArray3);
        JsonArray jsonArray4 = new JsonArray();
        for (ImmutableAttack hmMove : src.getHMMoves()) {
            jsonArray4.add(context.serialize((Object)hmMove));
        }
        object.add("hmMoves", (JsonElement)jsonArray4);
        object.add("tmMoves9", (JsonElement)this.serialize(src.getTMMoves9()));
        object.add("trMoves", (JsonElement)this.serialize(src.getTRMoves()));
        object.add("tmMoves8", (JsonElement)this.serialize(src.getTMMoves8()));
        object.add("tmMoves7", (JsonElement)this.serialize(src.getTMMoves7()));
        object.add("tmMoves6", (JsonElement)this.serialize(src.getTMMoves6()));
        object.add("tmMoves5", (JsonElement)this.serialize(src.getTMMoves5()));
        object.add("tmMoves4", (JsonElement)this.serialize(src.getTMMoves4()));
        object.add("tmMoves3", (JsonElement)this.serialize(src.getTMMoves3()));
        object.add("tmMoves2", (JsonElement)this.serialize(src.getTMMoves2()));
        object.add("tmMoves1", (JsonElement)this.serialize(src.getTMMoves1()));
        return object;
    }

    private JsonArray serialize(Set<? extends ITechnicalMove> moves) {
        JsonArray array = new JsonArray();
        for (ITechnicalMove iTechnicalMove : moves) {
            array.add(iTechnicalMove.getAttackName());
        }
        return array;
    }
}

