/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.palette;

import com.google.common.collect.Lists;
import com.pixelmonmod.pixelmon.api.pokemon.species.palette.locator.ModelLocator;
import com.pixelmonmod.pixelmon.api.util.ITranslatable;
import com.pixelmonmod.pixelmon.api.util.ResourceWithFallback;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.client.models.PixelmonModelHolder;
import com.pixelmonmod.pixelmon.entities.pixelmon.AbstractClientEntity;
import com.pixelmonmod.pixelmon.entities.pixelmon.particleEffects.PaletteParticles;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PaletteProperties
implements Cloneable,
ITranslatable {
    protected String name;
    protected String translationKey = "";
    protected ModelLocator[] modelLocators;
    protected ResourceWithFallback texture;
    protected ResourceWithFallback sprite;
    protected ResourceWithFallback emissive;
    protected PaletteParticles particle;
    private transient List<SoundEvent> sounds = Lists.newArrayList();
    private transient boolean soundRegistered = false;

    protected PaletteProperties() {
    }

    public PaletteProperties(String name, String translationKey, ModelLocator[] modelLocators, ResourceWithFallback texture, ResourceWithFallback emissive, ResourceWithFallback sprite, PaletteParticles particle) {
        this.name = name;
        this.translationKey = translationKey;
        this.modelLocators = modelLocators;
        this.texture = texture;
        this.emissive = emissive;
        this.sprite = sprite;
        this.particle = particle;
    }

    public PaletteProperties clone() {
        try {
            PaletteProperties palette = (PaletteProperties)super.clone();
            palette.name = this.name;
            palette.translationKey = this.translationKey;
            palette.modelLocators = this.modelLocators;
            palette.texture = this.texture;
            palette.sprite = this.sprite;
            palette.particle = this.particle;
            palette.emissive = this.emissive;
            palette.sounds = Lists.newArrayList();
            palette.sounds.addAll(this.sounds);
            palette.soundRegistered = this.soundRegistered;
            return palette;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getTranslationKey() {
        if (!this.translationKey.isEmpty()) {
            return this.translationKey;
        }
        return "pixelmon.palette." + this.name;
    }

    public void preloadModels() {
        for (ModelLocator modelLocator : this.modelLocators) {
            if (modelLocator == null) continue;
            modelLocator.getModel().getModel();
        }
    }

    public ModelLocator[] getModelLocators() {
        return this.modelLocators;
    }

    public PixelmonModelHolder<?> getModel(AbstractClientEntity entity) {
        if (this.modelLocators == null || this.modelLocators.length == 0) {
            return null;
        }
        int modelSlot = entity.getModelSlot();
        if (modelSlot < 0 || modelSlot >= this.modelLocators.length) {
            return this.modelLocators[0].getModel();
        }
        return this.modelLocators[modelSlot].getModel();
    }

    public void initModels() {
        for (ModelLocator modelLocator : this.modelLocators) {
            if (modelLocator == null) continue;
            modelLocator.init();
        }
    }

    public ResourceLocation getSprite() {
        return this.sprite.get();
    }

    public ResourceLocation getTexture() {
        return this.texture.get();
    }

    public boolean hasEmissiveTexture() {
        return this.emissive != null;
    }

    public ResourceLocation getEmissiveTexture() {
        return this.emissive.get();
    }

    public PaletteParticles getParticle() {
        return this.particle;
    }

    public String getParticleString() {
        if (this.getParticle() != null) {
            if (this.getParticle().getParticleType() != null) {
                return this.getParticle().getParticleType().getRegistryName().toString();
            }
            if (this.getParticle().getParticleSystem() != null) {
                return this.getParticle().getParticleSystem().getResource().toString();
            }
        }
        return "";
    }

    public void addSound(SoundEvent sound) {
        if (!this.soundRegistered) {
            this.sounds.clear();
        }
        this.sounds.add(sound);
        this.soundRegistered = true;
    }

    public SoundEvent getSound() {
        return RandomHelper.getRandomElementFromCollection(this.sounds);
    }

    private boolean hasSound() {
        return !this.sounds.isEmpty();
    }

    protected void resetSounds() {
        this.soundRegistered = false;
        this.sounds.clear();
    }

    public void setTexture(ResourceWithFallback texture) {
        this.texture = texture.ensureTexture();
    }

    public void setSprite(ResourceWithFallback sprite) {
        this.sprite = sprite.ensureTexture();
    }

    public boolean is(String palette) {
        return this.name.equalsIgnoreCase(palette);
    }

    public void setEmissive(ResourceWithFallback emissive) {
        this.emissive = emissive.ensureTexture();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean usingFallback() {
        for (ModelLocator modelLocator : this.modelLocators) {
            if (!modelLocator.usingFallback()) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PaletteProperties)) {
            return false;
        }
        PaletteProperties that = (PaletteProperties)o;
        return this.soundRegistered == that.soundRegistered && Objects.equals(this.getName(), that.getName()) && Arrays.equals(this.getModelLocators(), that.getModelLocators()) && Objects.equals(this.getTexture(), that.getTexture()) && Objects.equals(this.getSprite(), that.getSprite()) && Objects.equals(this.getParticle(), that.getParticle()) && Objects.equals(this.sounds, that.sounds);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), Arrays.hashCode(this.getModelLocators()), this.getTexture(), this.getSprite(), this.getParticle(), this.sounds, this.soundRegistered);
    }
}

