/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.species.moves;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.pixelmonmod.pixelmon.api.battles.attack.AttackRegistry;
import com.pixelmonmod.pixelmon.api.config.PixelmonConfigProxy;
import com.pixelmonmod.pixelmon.api.config.PixelmonServerConfig;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.species.Stats;
import com.pixelmonmod.pixelmon.api.pokemon.stats.BaseStatsLearnType;
import com.pixelmonmod.pixelmon.api.pokemon.stats.Moveset;
import com.pixelmonmod.pixelmon.api.util.helpers.RandomHelper;
import com.pixelmonmod.pixelmon.battles.attacks.Attack;
import com.pixelmonmod.pixelmon.battles.attacks.ImmutableAttack;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen1TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen2TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen3TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen4TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen5TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen6TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen7TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen8TechnicalRecords;
import com.pixelmonmod.pixelmon.enums.technicalmoves.Gen9TechnicalMachines;
import com.pixelmonmod.pixelmon.enums.technicalmoves.ITechnicalMove;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;

public class Moves {
    private final Map<Integer, Set<ImmutableAttack>> levelUpMoves;
    private final Set<ImmutableAttack> tmMoves;
    private final Set<ImmutableAttack> tutorMoves;
    private final Set<ImmutableAttack> eggMoves;
    private final Set<ImmutableAttack> transferMoves;
    private final Set<ImmutableAttack> hmMoves;
    private final Set<Gen9TechnicalMachines> tmMoves9;
    private final Set<Gen8TechnicalRecords> trMoves;
    private final Set<Gen8TechnicalMachines> tmMoves8;
    private final Set<Gen7TechnicalMachines> tmMoves7;
    private final Set<Gen6TechnicalMachines> tmMoves6;
    private final Set<Gen5TechnicalMachines> tmMoves5;
    private final Set<Gen4TechnicalMachines> tmMoves4;
    private final Set<Gen3TechnicalMachines> tmMoves3;
    private final Set<Gen2TechnicalMachines> tmMoves2;
    private final Set<Gen1TechnicalMachines> tmMoves1;
    private final List<ImmutableAttack> distinctMoves;

    private Moves(Map<Integer, Set<ImmutableAttack>> levelUpMoves, Set<ImmutableAttack> tmMoves, Set<ImmutableAttack> tutorMoves, Set<ImmutableAttack> eggMoves, Set<ImmutableAttack> transferMoves, Set<ImmutableAttack> hmMoves, Set<Gen9TechnicalMachines> tmMoves9, Set<Gen8TechnicalRecords> trMoves, Set<Gen8TechnicalMachines> tmMoves8, Set<Gen7TechnicalMachines> tmMoves7, Set<Gen6TechnicalMachines> tmMoves6, Set<Gen5TechnicalMachines> tmMoves5, Set<Gen4TechnicalMachines> tmMoves4, Set<Gen3TechnicalMachines> tmMoves3, Set<Gen2TechnicalMachines> tmMoves2, Set<Gen1TechnicalMachines> tmMoves1) {
        this.levelUpMoves = levelUpMoves;
        this.tmMoves = tmMoves;
        this.tutorMoves = tutorMoves;
        this.eggMoves = eggMoves;
        this.transferMoves = transferMoves;
        this.hmMoves = hmMoves;
        this.tmMoves9 = tmMoves9;
        this.trMoves = trMoves;
        this.tmMoves8 = tmMoves8;
        this.tmMoves7 = tmMoves7;
        this.tmMoves6 = tmMoves6;
        this.tmMoves5 = tmMoves5;
        this.tmMoves4 = tmMoves4;
        this.tmMoves3 = tmMoves3;
        this.tmMoves2 = tmMoves2;
        this.tmMoves1 = tmMoves1;
        ArrayList<ImmutableAttack> moves = new ArrayList<ImmutableAttack>();
        moves.addAll(this.getAllLevelUpMoves());
        moves.addAll(this.getTMMoves());
        for (Gen8TechnicalRecords trMove : this.getTRMoves()) {
            moves.add(trMove.getAttack());
        }
        moves.addAll(Lists.newArrayList(this.getHMMoves()));
        moves.addAll(this.getTutorMoves());
        moves.addAll(this.getTransferMoves());
        moves.addAll(this.getEggMoves());
        ArrayList<ImmutableAttack> distinctMoves = new ArrayList<ImmutableAttack>();
        for (ImmutableAttack attack : moves) {
            if (distinctMoves.contains(attack)) continue;
            distinctMoves.add(attack);
        }
        this.distinctMoves = distinctMoves;
    }

    public void initLevelUpMoves() {
        if (this.levelUpMoves.containsKey(0)) {
            if (!this.levelUpMoves.containsKey(1)) {
                this.levelUpMoves.put(1, new LinkedHashSet());
            }
            this.levelUpMoves.get(1).addAll((Collection<ImmutableAttack>)this.levelUpMoves.get(0));
            this.levelUpMoves.remove(0);
        }
    }

    public Map<Integer, Set<ImmutableAttack>> getPokemonLevelUpMoves() {
        return this.levelUpMoves;
    }

    public Set<ImmutableAttack> getAllLevelUpMoves() {
        HashSet allAttacks = Sets.newHashSet();
        for (Set<ImmutableAttack> attacks : this.levelUpMoves.values()) {
            allAttacks.addAll(attacks);
        }
        return allAttacks;
    }

    public Set<ImmutableAttack> getTMMoves() {
        return this.tmMoves;
    }

    public Set<ImmutableAttack> getTutorMoves() {
        return this.tutorMoves;
    }

    public Set<ImmutableAttack> getEggMoves() {
        return this.eggMoves;
    }

    public Set<ImmutableAttack> getTransferMoves() {
        return this.transferMoves;
    }

    public Set<ImmutableAttack> getHMMoves() {
        return this.hmMoves;
    }

    public Set<Gen9TechnicalMachines> getTMMoves9() {
        return this.tmMoves9;
    }

    public Set<Gen8TechnicalRecords> getTRMoves() {
        return this.trMoves;
    }

    public Set<Gen8TechnicalMachines> getTMMoves8() {
        return this.tmMoves8;
    }

    public Set<Gen7TechnicalMachines> getTMMoves7() {
        return this.tmMoves7;
    }

    public Set<Gen6TechnicalMachines> getTMMoves6() {
        return this.tmMoves6;
    }

    public Set<Gen5TechnicalMachines> getTMMoves5() {
        return this.tmMoves5;
    }

    public Set<Gen4TechnicalMachines> getTMMoves4() {
        return this.tmMoves4;
    }

    public Set<Gen3TechnicalMachines> getTMMoves3() {
        return this.tmMoves3;
    }

    public Set<Gen2TechnicalMachines> getTMMoves2() {
        return this.tmMoves2;
    }

    public Set<Gen1TechnicalMachines> getTMMoves1() {
        return this.tmMoves1;
    }

    public Set<ITechnicalMove> getGenerationMoves(int generation) {
        switch (generation) {
            case 1: {
                return Sets.newHashSet(this.getTMMoves1());
            }
            case 2: {
                return Sets.newHashSet(this.getTMMoves2());
            }
            case 3: {
                return Sets.newHashSet(this.getTMMoves3());
            }
            case 4: {
                return Sets.newHashSet(this.getTMMoves4());
            }
            case 5: {
                return Sets.newHashSet(this.getTMMoves5());
            }
            case 6: {
                return Sets.newHashSet(this.getTMMoves6());
            }
            case 7: {
                return Sets.newHashSet(this.getTMMoves7());
            }
            case 8: {
                HashSet gen8 = Sets.newHashSet(this.getTMMoves8());
                gen8.addAll(Lists.newArrayList(this.getTRMoves()));
                return gen8;
            }
            case 9: {
                return Sets.newHashSet(this.getTMMoves9());
            }
        }
        return Sets.newHashSet();
    }

    public List<ImmutableAttack> getMovesUpToLevel(int level) {
        LinkedHashSet attacks = new LinkedHashSet();
        for (int i = 0; i <= level; ++i) {
            if (this.levelUpMoves == null || !this.levelUpMoves.containsKey(i)) continue;
            attacks.addAll(this.levelUpMoves.get(i));
        }
        return new ArrayList<ImmutableAttack>(attacks);
    }

    public List<ImmutableAttack> getMovesAtLevel(int level) {
        if (level == 0) {
            level = 1;
        }
        if (this.levelUpMoves != null && this.levelUpMoves.containsKey(level)) {
            return new ArrayList<ImmutableAttack>((Collection)this.levelUpMoves.get(level));
        }
        return new ArrayList<ImmutableAttack>();
    }

    public Moveset loadMoveset(int level) {
        return this.loadMoveset(level, null);
    }

    public Moveset loadMoveset(int level, @Nullable Ability ability) {
        List<ImmutableAttack> attackList = this.getMovesUpToLevel(level);
        while (attackList.size() > 4) {
            if (PixelmonConfigProxy.getSpawning().isUseRecentLevelMoves()) {
                attackList.remove(0);
                continue;
            }
            RandomHelper.removeRandomElementFromList(attackList);
        }
        if (attackList.isEmpty()) {
            attackList.add(AttackRegistry.TACKLE.orElse(null));
        }
        Moveset moveset = new Moveset();
        moveset.addImmutable(attackList);
        moveset.setAbility(ability);
        return moveset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<Pair<Integer, ImmutableAttack>> getFormatLevelMoves() {
        ArrayList<Pair<Integer, ImmutableAttack>> check = new ArrayList<Pair<Integer, ImmutableAttack>>();
        for (Map.Entry<Integer, Set<ImmutableAttack>> entry : this.levelUpMoves.entrySet()) {
            Integer lv = entry.getKey();
            ArrayList ab = Lists.newArrayList((Iterable)entry.getValue());
            for (ImmutableAttack a : ab) {
                check.add((Pair<Integer, ImmutableAttack>)Pair.of((Object)lv, (Object)a));
            }
        }
        check.sort(Comparator.comparingInt(Pair::getLeft));
        return check;
    }

    public List<ImmutableAttack> getAllMoves() {
        return this.distinctMoves;
    }

    public boolean canLearn(ImmutableAttack immutableAttack) {
        List<ImmutableAttack> allMoves = this.getAllMoves();
        for (ImmutableAttack attack : allMoves) {
            if (!attack.isAttack(immutableAttack)) continue;
            return true;
        }
        return false;
    }

    public boolean canLearn(Stats stats, ImmutableAttack attack, BaseStatsLearnType ... types) {
        for (BaseStatsLearnType type : types) {
            if (!type.canLearn(stats, attack)) continue;
            return true;
        }
        return false;
    }

    @Nonnull
    public List<ITechnicalMove> getTMMovesFor(int gen) {
        switch (gen) {
            case 1: {
                return this.tmMoves1 != null ? new ArrayList<Gen1TechnicalMachines>(this.tmMoves1) : Collections.emptyList();
            }
            case 2: {
                return this.tmMoves2 != null ? new ArrayList<Gen2TechnicalMachines>(this.tmMoves2) : Collections.emptyList();
            }
            case 3: {
                return this.tmMoves3 != null ? new ArrayList<Gen3TechnicalMachines>(this.tmMoves3) : Collections.emptyList();
            }
            case 4: {
                return this.tmMoves4 != null ? new ArrayList<Gen4TechnicalMachines>(this.tmMoves4) : Collections.emptyList();
            }
            case 5: {
                return this.tmMoves5 != null ? new ArrayList<Gen5TechnicalMachines>(this.tmMoves5) : Collections.emptyList();
            }
            case 6: {
                return this.tmMoves6 != null ? new ArrayList<Gen6TechnicalMachines>(this.tmMoves6) : Collections.emptyList();
            }
            case 7: {
                return this.tmMoves7 != null ? new ArrayList<Gen7TechnicalMachines>(this.tmMoves7) : Collections.emptyList();
            }
            case 8: {
                return this.tmMoves8 != null ? new ArrayList<Gen8TechnicalMachines>(this.tmMoves8) : Collections.emptyList();
            }
            case 9: {
                return this.tmMoves9 != null ? new ArrayList<Gen9TechnicalMachines>(this.tmMoves9) : Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    public boolean canLearn(ITechnicalMove move) {
        if (PixelmonServerConfig.superUniversalTMs) {
            return this.canLearn(move.getAttack()) || this.getTMMovesFor(move.getGeneration()).contains(move) || this.canLearnViaOtherSet(move);
        }
        if (PixelmonServerConfig.universalTMs) {
            return this.canLearnTMTRHM(move.getAttack()) || this.getTMMovesFor(move.getGeneration()).contains(move) || this.canLearnViaOtherSet(move);
        }
        return this.tmMoves9 != null && this.tmMoves9.contains(move) || this.trMoves != null && this.trMoves.contains(move) || this.tmMoves8 != null && this.tmMoves8.contains(move) || this.tmMoves7 != null && this.tmMoves7.contains(move) || this.tmMoves6 != null && this.tmMoves6.contains(move) || this.tmMoves5 != null && this.tmMoves5.contains(move) || this.tmMoves4 != null && this.tmMoves4.contains(move) || this.tmMoves3 != null && this.tmMoves3.contains(move) || this.tmMoves2 != null && this.tmMoves2.contains(move) || this.tmMoves1 != null && this.tmMoves1.contains(move);
    }

    public boolean canLearnViaOtherSet(ITechnicalMove move) {
        return !(move instanceof Gen9TechnicalMachines) && this.tmMoves9 != null && this.isMoveInSet(this.tmMoves9, move.getAttackName()) || !(move instanceof Gen8TechnicalRecords) && this.trMoves != null && this.isMoveInSet(this.trMoves, move.getAttackName()) || !(move instanceof Gen8TechnicalMachines) && this.tmMoves8 != null && this.isMoveInSet(this.tmMoves8, move.getAttackName()) || !(move instanceof Gen7TechnicalMachines) && this.tmMoves7 != null && this.isMoveInSet(this.tmMoves7, move.getAttackName()) || !(move instanceof Gen6TechnicalMachines) && this.tmMoves6 != null && this.isMoveInSet(this.tmMoves6, move.getAttackName()) || !(move instanceof Gen5TechnicalMachines) && this.tmMoves5 != null && this.isMoveInSet(this.tmMoves5, move.getAttackName()) || !(move instanceof Gen4TechnicalMachines) && this.tmMoves4 != null && this.isMoveInSet(this.tmMoves4, move.getAttackName()) || !(move instanceof Gen3TechnicalMachines) && this.tmMoves3 != null && this.isMoveInSet(this.tmMoves3, move.getAttackName()) || !(move instanceof Gen2TechnicalMachines) && this.tmMoves2 != null && this.isMoveInSet(this.tmMoves2, move.getAttackName()) || !(move instanceof Gen1TechnicalMachines) && this.tmMoves1 != null && this.isMoveInSet(this.tmMoves1, move.getAttackName());
    }

    public Set<ImmutableAttack> getAllTMTRHMMoves() {
        HashSet<ImmutableAttack> moves = new HashSet<ImmutableAttack>();
        moves.addAll(Lists.newArrayList(this.getTMMoves()));
        moves.addAll(this.getTRMoves().stream().map(ITechnicalMove::getAttack).collect(Collectors.toList()));
        moves.addAll(this.getHMMoves());
        return moves;
    }

    public boolean canLearnTMTRHM(ImmutableAttack attackName) {
        Set<ImmutableAttack> moves = this.getAllTMTRHMMoves();
        for (ImmutableAttack attack : moves) {
            if (!attack.isAttack(attackName)) continue;
            return true;
        }
        return false;
    }

    public boolean isMoveInSet(Set<? extends ITechnicalMove> tms, String attack) {
        for (ITechnicalMove iTechnicalMove : tms) {
            if (!attack.equalsIgnoreCase(iTechnicalMove.getAttackName())) continue;
            return true;
        }
        return false;
    }

    private static LinkedHashSet<Attack> severReferences(Collection<Attack> attacks) {
        LinkedHashSet<Attack> newAttacks = new LinkedHashSet<Attack>(attacks.size());
        for (Attack oldAttack : attacks) {
            if (oldAttack == null) continue;
            newAttacks.add(new Attack(oldAttack.getActualMove()));
        }
        return newAttacks;
    }

    public static class Builder {
        private final Map<Integer, Set<ImmutableAttack>> levelUpMoves = Maps.newLinkedHashMap();
        public final Set<ImmutableAttack> tmMoves = Sets.newLinkedHashSet();
        public final Set<ImmutableAttack> tutorMoves = Sets.newLinkedHashSet();
        public final Set<ImmutableAttack> eggMoves = Sets.newLinkedHashSet();
        private final Set<ImmutableAttack> transferMoves = Sets.newLinkedHashSet();
        private final Set<ImmutableAttack> hmMoves = Sets.newLinkedHashSet();
        private final Set<Gen9TechnicalMachines> tmMoves9 = Sets.newLinkedHashSet();
        private final Set<Gen8TechnicalRecords> trMoves = Sets.newLinkedHashSet();
        private final Set<Gen8TechnicalMachines> tmMoves8 = Sets.newLinkedHashSet();
        private final Set<Gen7TechnicalMachines> tmMoves7 = Sets.newLinkedHashSet();
        private final Set<Gen6TechnicalMachines> tmMoves6 = Sets.newLinkedHashSet();
        private final Set<Gen5TechnicalMachines> tmMoves5 = Sets.newLinkedHashSet();
        private final Set<Gen4TechnicalMachines> tmMoves4 = Sets.newLinkedHashSet();
        private final Set<Gen3TechnicalMachines> tmMoves3 = Sets.newLinkedHashSet();
        private final Set<Gen2TechnicalMachines> tmMoves2 = Sets.newLinkedHashSet();
        private final Set<Gen1TechnicalMachines> tmMoves1 = Sets.newLinkedHashSet();

        protected Builder() {
        }

        public Builder levelUpMoves(int id, ImmutableAttack ... attacks) {
            this.levelUpMoves.computeIfAbsent(id, ___ -> Sets.newLinkedHashSet()).addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder levelUpMoves(int id, List<ImmutableAttack> attacks) {
            this.levelUpMoves.computeIfAbsent(id, ___ -> Sets.newLinkedHashSet()).addAll(attacks);
            return this;
        }

        public Builder tmMoves(ImmutableAttack ... attacks) {
            this.tmMoves.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves(List<ImmutableAttack> attacks) {
            this.tmMoves.addAll(attacks);
            return this;
        }

        public Builder tutorMoves(ImmutableAttack ... attacks) {
            this.tutorMoves.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tutorMoves(List<ImmutableAttack> attacks) {
            this.tutorMoves.addAll(attacks);
            return this;
        }

        public Builder eggMoves(ImmutableAttack ... attacks) {
            this.eggMoves.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder eggMoves(List<ImmutableAttack> attacks) {
            this.eggMoves.addAll(attacks);
            return this;
        }

        public Builder transferMoves(ImmutableAttack ... attacks) {
            this.transferMoves.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder transferMoves(List<ImmutableAttack> attacks) {
            this.transferMoves.addAll(attacks);
            return this;
        }

        public Builder hmMoves(ImmutableAttack ... attacks) {
            this.hmMoves.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder hmMoves(List<ImmutableAttack> attacks) {
            this.hmMoves.addAll(attacks);
            return this;
        }

        public Builder tmMoves9(Gen9TechnicalMachines ... attacks) {
            this.tmMoves9.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves9(List<Gen9TechnicalMachines> attacks) {
            this.tmMoves9.addAll(attacks);
            return this;
        }

        public Builder trMoves(Gen8TechnicalRecords ... attacks) {
            this.trMoves.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder trMoves(List<Gen8TechnicalRecords> attacks) {
            this.trMoves.addAll(attacks);
            return this;
        }

        public Builder tmMoves8(Gen8TechnicalMachines ... attacks) {
            this.tmMoves8.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves8(List<Gen8TechnicalMachines> attacks) {
            this.tmMoves8.addAll(attacks);
            return this;
        }

        public Builder tmMoves7(Gen7TechnicalMachines ... attacks) {
            this.tmMoves7.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves7(List<Gen7TechnicalMachines> attacks) {
            this.tmMoves7.addAll(attacks);
            return this;
        }

        public Builder tmMoves6(Gen6TechnicalMachines ... attacks) {
            this.tmMoves6.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves6(List<Gen6TechnicalMachines> attacks) {
            this.tmMoves6.addAll(attacks);
            return this;
        }

        public Builder tmMoves5(Gen5TechnicalMachines ... attacks) {
            this.tmMoves5.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves5(List<Gen5TechnicalMachines> attacks) {
            this.tmMoves5.addAll(attacks);
            return this;
        }

        public Builder tmMoves4(Gen4TechnicalMachines ... attacks) {
            this.tmMoves4.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves4(List<Gen4TechnicalMachines> attacks) {
            this.tmMoves4.addAll(attacks);
            return this;
        }

        public Builder tmMoves3(Gen3TechnicalMachines ... attacks) {
            this.tmMoves3.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves3(List<Gen3TechnicalMachines> attacks) {
            this.tmMoves3.addAll(attacks);
            return this;
        }

        public Builder tmMoves2(Gen2TechnicalMachines ... attacks) {
            this.tmMoves2.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves2(List<Gen2TechnicalMachines> attacks) {
            this.tmMoves2.addAll(attacks);
            return this;
        }

        public Builder tmMoves1(Gen1TechnicalMachines ... attacks) {
            this.tmMoves1.addAll(Arrays.asList(attacks));
            return this;
        }

        public Builder tmMoves1(List<Gen1TechnicalMachines> attacks) {
            this.tmMoves1.addAll(attacks);
            return this;
        }

        public Moves build() {
            return new Moves(this.levelUpMoves, this.tmMoves, this.tutorMoves, this.eggMoves, this.transferMoves, this.hmMoves, this.tmMoves9, this.trMoves, this.tmMoves8, this.tmMoves7, this.tmMoves6, this.tmMoves5, this.tmMoves4, this.tmMoves3, this.tmMoves2, this.tmMoves1);
        }
    }
}

