/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.egg.impl;

import com.pixelmonmod.pixelmon.api.pokemon.egg.EggGroup;
import com.pixelmonmod.pixelmon.api.pokemon.species.gender.Gender;
import java.util.List;
import java.util.Locale;

public abstract class AbstractEggGroup
implements EggGroup {
    protected final int index;
    protected final String name;

    protected AbstractEggGroup(int index, String name) {
        this.index = index;
        this.name = name;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public String getKey() {
        return this.name;
    }

    @Override
    public boolean canBreed(Gender first, Gender second) {
        return first.isCompatible(second);
    }

    @Override
    public boolean canBreedWith(List<EggGroup> others) {
        for (EggGroup other : others) {
            if (!this.canBreedWith(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canBreedWith(EggGroup ... others) {
        for (EggGroup other : others) {
            if (!this.canBreedWith(other)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getTranslationKey() {
        return "pixelmon.egg_group." + this.name.toLowerCase(Locale.ROOT);
    }
}

