/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.api.pokemon.ability.abilities;

import com.pixelmonmod.pixelmon.api.pokemon.Element;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbstractAbility;
import com.pixelmonmod.pixelmon.battles.controller.participants.PixelmonWrapper;
import com.pixelmonmod.pixelmon.battles.status.AuraStatus;
import com.pixelmonmod.pixelmon.battles.status.GlobalStatusBase;
import com.pixelmonmod.pixelmon.battles.status.StatusType;
import java.util.Locale;

public abstract class Aura
extends AbstractAbility {
    private Element boostType;
    private StatusType auraStatus;

    public Aura(Element boostType, StatusType auraStatus) {
        this.boostType = boostType;
        this.auraStatus = auraStatus;
    }

    @Override
    public void applySwitchInEffect(PixelmonWrapper newPokemon) {
        GlobalStatusBase current = newPokemon.bc.globalStatusController.getGlobalStatus(this.auraStatus);
        if (current == null) {
            newPokemon.addGlobalStatus(new AuraStatus(this.boostType, this.auraStatus));
            newPokemon.bc.sendToAll("pixelmon.abilities." + this.auraStatus.toString().toLowerCase(Locale.ROOT), newPokemon.getNickname());
        }
    }

    @Override
    public void applySwitchOutEffect(PixelmonWrapper oldPokemon) {
        this.removeAuraStatus(oldPokemon);
    }

    @Override
    public void onAbilityLost(PixelmonWrapper pokemon) {
        this.removeAuraStatus(pokemon);
    }

    private void removeAuraStatus(PixelmonWrapper pokemon) {
        for (PixelmonWrapper pw : pokemon.bc.getActivePokemon()) {
            if (pw == pokemon || !pw.getBattleAbility().getClass().isAssignableFrom(this.getClass())) continue;
            return;
        }
        pokemon.bc.globalStatusController.removeGlobalStatus(this.auraStatus);
    }
}

