/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.ai;

import com.pixelmonmod.pixelmon.api.battles.BattleEndCause;
import com.pixelmonmod.pixelmon.api.battles.BattleType;
import com.pixelmonmod.pixelmon.api.moveskills.MoveSkill;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.registries.PixelmonBlocks;
import com.pixelmonmod.pixelmon.api.registries.PixelmonItems;
import com.pixelmonmod.pixelmon.api.storage.PlayerPartyStorage;
import com.pixelmonmod.pixelmon.api.storage.StorageProxy;
import com.pixelmonmod.pixelmon.battles.BattleQuery;
import com.pixelmonmod.pixelmon.battles.BattleRegistry;
import com.pixelmonmod.pixelmon.battles.api.rules.teamselection.TeamSelectionRegistry;
import com.pixelmonmod.pixelmon.battles.controller.BattleController;
import com.pixelmonmod.pixelmon.battles.controller.participants.BattleParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.PlayerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.TrainerParticipant;
import com.pixelmonmod.pixelmon.battles.controller.participants.WildPixelmonParticipant;
import com.pixelmonmod.pixelmon.comm.ChatHandler;
import com.pixelmonmod.pixelmon.comm.EnumUpdateType;
import com.pixelmonmod.pixelmon.entities.npcs.NPCTrainer;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import com.pixelmonmod.pixelmon.init.registry.EffectRegistration;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.stream.Collectors;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;

public class ExecuteActionGoal
extends Goal {
    private CreatureEntity parent;
    private MoveSkill moveSkill = null;

    public ExecuteActionGoal(CreatureEntity entity) {
        this.parent = entity;
        this.func_220684_a(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
    }

    public boolean func_75250_a() {
        LivingEntity attackTarget;
        if (this.parent.func_70638_az() == null) {
            return false;
        }
        if (this.parent instanceof PixelmonEntity) {
            ServerPlayerEntity player;
            PixelmonEntity pokemon = (PixelmonEntity)this.parent;
            if (pokemon.getAggressionTimer() > 0) {
                return false;
            }
            if (pokemon.battleController != null) {
                return false;
            }
            if (pokemon.hitByPokeball != null) {
                return false;
            }
            if (pokemon.getBossTier().isBoss()) {
                return false;
            }
            if (pokemon.getOwner() != null && BattleRegistry.getBattle((PlayerEntity)(player = (ServerPlayerEntity)pokemon.getOwner())) != null) {
                return false;
            }
        } else if (((NPCTrainer)this.parent).battleController != null) {
            return false;
        }
        if ((attackTarget = this.parent.func_70638_az()) instanceof PlayerEntity && (((PlayerEntity)attackTarget).func_184812_l_() || attackTarget.func_175149_v())) {
            this.parent.func_70624_b(null);
            return false;
        }
        double distance = 2.0;
        if (this.parent instanceof NPCTrainer) {
            distance = ((NPCTrainer)this.parent).getEngageDistance();
        }
        if (this.parent instanceof PixelmonEntity) {
            PixelmonEntity pixelmon = (PixelmonEntity)this.parent;
            String skillId = pixelmon.skillId;
            if (skillId != null) {
                this.moveSkill = MoveSkill.getMoveSkillByID(skillId);
                if (this.moveSkill != null) {
                    distance = this.moveSkill.range;
                }
            }
        }
        return (double)attackTarget.func_70032_d((Entity)this.parent) < distance;
    }

    public void func_75249_e() {
    }

    public void func_75246_d() {
        LivingEntity attackTarget = this.parent.func_70638_az();
        this.parent.func_70624_b(null);
        if (this.parent instanceof PixelmonEntity) {
            ((PixelmonEntity)this.parent).update(EnumUpdateType.Target);
        }
        if (this.parent instanceof PixelmonEntity) {
            PixelmonEntity user = (PixelmonEntity)this.parent;
            if (this.moveSkill != null) {
                if (attackTarget instanceof PixelmonEntity && this.moveSkill.hasTargetType(MoveSkill.EnumTargetType.POKEMON)) {
                    this.moveSkill.onUsed(user, attackTarget, MoveSkill.EnumTargetType.POKEMON);
                } else if (attackTarget instanceof ServerPlayerEntity && this.moveSkill.hasTargetType(MoveSkill.EnumTargetType.PLAYER)) {
                    this.moveSkill.onUsed(user, attackTarget, MoveSkill.EnumTargetType.PLAYER);
                } else if (this.moveSkill.hasTargetType(MoveSkill.EnumTargetType.MISC_ENTITY)) {
                    this.moveSkill.onUsed(user, attackTarget, MoveSkill.EnumTargetType.MISC_ENTITY);
                }
                return;
            }
        }
        if (attackTarget instanceof PlayerEntity) {
            Pokemon firstPokemon;
            BlockItem currentItemBlock;
            ServerPlayerEntity player = (ServerPlayerEntity)attackTarget;
            if (BattleRegistry.getBattle((PlayerEntity)player) != null) {
                return;
            }
            if (this.parent instanceof NPCTrainer && !((NPCTrainer)this.parent).canStartBattle((PlayerEntity)player, false)) {
                return;
            }
            if (this.parent instanceof PixelmonEntity && ((PixelmonEntity)this.parent).belongsTo((PlayerEntity)player)) {
                return;
            }
            if (player.func_70644_a((Effect)EffectRegistration.AVOIDANCE.get())) {
                return;
            }
            Item currentItem = ((ItemStack)player.field_71071_by.field_70462_a.get(player.field_71071_by.field_70461_c)).func_77973_b();
            if (currentItem == PixelmonItems.trainer_editor) {
                return;
            }
            if (currentItem instanceof BlockItem && (currentItemBlock = (BlockItem)currentItem).func_179223_d() == PixelmonBlocks.pixelmon_spawner.getBlock()) {
                return;
            }
            PlayerPartyStorage storage = StorageProxy.getParty(player);
            if (storage.guiOpened || storage.countAblePokemon() < 1) {
                return;
            }
            BattleType battleType = BattleType.SINGLE;
            if (this.parent instanceof NPCTrainer) {
                NPCTrainer trainer = (NPCTrainer)this.parent;
                battleType = trainer.getBattleType();
                if (!trainer.battleRules.isDefault()) {
                    TeamSelectionRegistry.addTeamSelection(trainer.battleRules, true, trainer.getPokemonStorage(), StorageProxy.getParty(player));
                    return;
                }
            }
            if ((firstPokemon = storage.findOne(Pokemon::canBattle)) == null) {
                return;
            }
            PixelmonEntity pixelmon = firstPokemon.getOrSpawnPixelmon((Entity)player);
            PlayerParticipant playerPart = battleType == BattleType.SINGLE ? new PlayerParticipant(player, pixelmon) : new PlayerParticipant(player, storage.findAll(Pokemon::canBattle), battleType.getNumPokemon());
            BattleParticipant participant = this.getThisParticipant(attackTarget);
            if (participant instanceof PlayerParticipant && this.parent instanceof PixelmonEntity) {
                new BattleQuery((ServerPlayerEntity)((PixelmonEntity)this.parent).getOwner(), (PixelmonEntity)this.parent, player, pixelmon);
            } else if (pixelmon != null) {
                pixelmon.startBattle(playerPart, participant);
            }
            return;
        }
        if (!(this.parent instanceof PixelmonEntity)) {
            return;
        }
        PixelmonEntity userPokemon = (PixelmonEntity)this.parent;
        if (attackTarget instanceof NPCTrainer) {
            NPCTrainer trainerEntity = (NPCTrainer)attackTarget;
            if (!trainerEntity.canStartBattle((PlayerEntity)((ServerPlayerEntity)((PixelmonEntity)this.parent).getOwner()), true)) {
                return;
            }
            BattleController bc = trainerEntity.getBattleController();
            if (bc != null) {
                if (bc.battleEnded) {
                    bc.endBattle(BattleEndCause.FORCE);
                } else {
                    ChatHandler.sendChat((Entity)userPokemon.getOwner(), "pixelmon.entitytrainer.inbattle", new Object[0]);
                    return;
                }
            }
            BattleType battleType = trainerEntity.getBattleType();
            BattleParticipant participant = this.getThisParticipant(attackTarget);
            if (participant instanceof PlayerParticipant && userPokemon.getOwner() instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)userPokemon.getOwner();
                if (trainerEntity.battleRules.isDefault()) {
                    if (userPokemon != null) {
                        PlayerParticipant playerPart;
                        userPokemon.onSendout();
                        TrainerParticipant trainer = new TrainerParticipant(trainerEntity, (PlayerEntity)player, battleType.getNumPokemon());
                        if (battleType == BattleType.SINGLE) {
                            playerPart = new PlayerParticipant(player, userPokemon);
                        } else {
                            PlayerPartyStorage storage = StorageProxy.getParty(player);
                            ArrayList<Pokemon> list = new ArrayList<Pokemon>();
                            list.add(userPokemon.getPokemon());
                            list.addAll(storage.getTeam().stream().filter(p -> !p.isFainted() && p != userPokemon.getPokemon()).collect(Collectors.toList()));
                            playerPart = new PlayerParticipant(player, list, 2);
                        }
                        userPokemon.startBattle((BattleParticipant)playerPart, (BattleParticipant)trainer, trainerEntity.battleRules);
                    }
                } else {
                    TeamSelectionRegistry.addTeamSelection(trainerEntity.battleRules, true, trainerEntity.getPokemonStorage(), StorageProxy.getParty(player));
                }
                return;
            }
        }
        if (!(attackTarget instanceof PixelmonEntity)) {
            return;
        }
        PixelmonEntity target = (PixelmonEntity)attackTarget;
        BattleParticipant participant = this.getThisParticipant(attackTarget);
        if (participant instanceof WildPixelmonParticipant) {
            if (target.getBossTier().isBoss() || userPokemon.getBossTier().isBoss()) {
                return;
            }
            if (target.hasPalette() || userPokemon.hasPalette()) {
                return;
            }
            if (target.getOwner() != null) {
                return;
            }
        }
        if (target.hitByPokeball != null) {
            return;
        }
        if (target.battleController != null) {
            return;
        }
        if (target.func_110143_aJ() <= 0.0f || !target.func_70089_S()) {
            return;
        }
        if (target.getOwner() == null) {
            userPokemon.startBattle(participant, new WildPixelmonParticipant(target));
        } else if (userPokemon.getOwner() != target.getOwner()) {
            new BattleQuery((ServerPlayerEntity)userPokemon.getOwner(), userPokemon, (ServerPlayerEntity)target.getOwner(), target);
        }
    }

    private BattleParticipant getThisParticipant(LivingEntity attackTarget) throws IllegalStateException {
        if (this.parent instanceof NPCTrainer) {
            NPCTrainer trainer = (NPCTrainer)this.parent;
            return new TrainerParticipant(trainer, (PlayerEntity)((ServerPlayerEntity)attackTarget), trainer.getBattleType().getNumPokemon());
        }
        PixelmonEntity pixelmon = (PixelmonEntity)this.parent;
        if (pixelmon.hasOwner()) {
            return new PlayerParticipant((ServerPlayerEntity)pixelmon.getOwner(), pixelmon);
        }
        return new WildPixelmonParticipant(pixelmon);
    }
}

