/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.api.pokemon.requirement.impl;

import com.google.common.collect.Sets;
import com.pixelmonmod.api.pokemon.requirement.AbstractPokemonRequirement;
import com.pixelmonmod.api.requirement.Requirement;
import com.pixelmonmod.pixelmon.api.pokemon.Pokemon;
import com.pixelmonmod.pixelmon.api.pokemon.ability.Ability;
import com.pixelmonmod.pixelmon.api.pokemon.ability.AbilityRegistry;
import com.pixelmonmod.pixelmon.entities.pixelmon.PixelmonEntity;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class AbilityRequirement
extends AbstractPokemonRequirement<Ability> {
    private static final Set<String> KEYS = Sets.newHashSet((Object[])new String[]{"ability", "ab"});
    private Ability ability;

    public AbilityRequirement() {
        super(KEYS);
    }

    public AbilityRequirement(Ability ability) {
        this();
        this.ability = ability;
    }

    @Override
    public List<Requirement<Pokemon, PixelmonEntity, ?>> createSimple(String key, String spec) {
        if (!spec.startsWith(key + ":")) {
            return Collections.emptyList();
        }
        String[] args = spec.split(key + ":");
        if (args.length == 0 || args.length == 1) {
            return Collections.emptyList();
        }
        Ability ability = AbilityRegistry.getAbility(args[1]).orElse(null);
        if (ability == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.createInstance(ability));
    }

    @Override
    public Requirement<Pokemon, PixelmonEntity, Ability> createInstance(Ability value) {
        return new AbilityRequirement(value);
    }

    @Override
    public boolean isDataMatch(Pokemon pixelmon) {
        return Objects.equals(this.ability, pixelmon.getAbility());
    }

    @Override
    public void applyData(Pokemon pixelmon) {
        pixelmon.setAbility(this.ability.getNewInstance());
        pixelmon.overrideAbilitySlot();
    }

    @Override
    public Ability getValue() {
        return this.ability;
    }
}

