import os
import glob

BASE_FOLDER = "."          # Main folder where the Pokemon folders are
LIST_FILE = "pokemonlist.txt"

missing = []

# Get all folders in the base directory
all_folders = [
    f for f in os.listdir(BASE_FOLDER)
    if os.path.isdir(os.path.join(BASE_FOLDER, f))
]

# Read Pokémon names
with open(LIST_FILE, "r", encoding="utf-8") as f:
    pokemon_names = [line.strip().lower() for line in f if line.strip()]

for pokemon in pokemon_names:
    matching_folders = [
        folder for folder in all_folders
        if pokemon in folder.lower()
    ]

    if not matching_folders:
        print(f"NO MATCHING FOLDER FOUND FOR: {pokemon}")
        continue

    for folder in matching_folders:
        folder_path = os.path.join(BASE_FOLDER, folder)

        bronze_files = glob.glob(os.path.join(folder_path, "*_bronze.png"))

        if not bronze_files:
            missing.append(folder)

# Remove duplicates
missing = sorted(set(missing))

# Final output
print("\n---- FOLDERS MISSING *_bronze.png ----")
for folder in missing:
    print(folder)

print(f"\nTotal missing: {len(missing)}")
